/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProviderServiceRequest extends EntityResolutionRequest implements
        ToCopyableBuilder<GetProviderServiceRequest.Builder, GetProviderServiceRequest> {
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerName").getter(getter(GetProviderServiceRequest::providerName))
            .setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("providerName").build()).build();

    private static final SdkField<String> PROVIDER_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerServiceName").getter(getter(GetProviderServiceRequest::providerServiceName))
            .setter(setter(Builder::providerServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("providerServiceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NAME_FIELD,
            PROVIDER_SERVICE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String providerName;

    private final String providerServiceName;

    private GetProviderServiceRequest(BuilderImpl builder) {
        super(builder);
        this.providerName = builder.providerName;
        this.providerServiceName = builder.providerServiceName;
    }

    /**
     * <p>
     * The name of the provider. This name is typically the company name.
     * </p>
     * 
     * @return The name of the provider. This name is typically the company name.
     */
    public final String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the product that the provider service provides.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the product that the provider service provides.
     */
    public final String providerServiceName() {
        return providerServiceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(providerServiceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProviderServiceRequest)) {
            return false;
        }
        GetProviderServiceRequest other = (GetProviderServiceRequest) obj;
        return Objects.equals(providerName(), other.providerName())
                && Objects.equals(providerServiceName(), other.providerServiceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProviderServiceRequest").add("ProviderName", providerName())
                .add("ProviderServiceName", providerServiceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "providerName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "providerServiceName":
            return Optional.ofNullable(clazz.cast(providerServiceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("providerName", PROVIDER_NAME_FIELD);
        map.put("providerServiceName", PROVIDER_SERVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProviderServiceRequest, T> g) {
        return obj -> g.apply((GetProviderServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EntityResolutionRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProviderServiceRequest> {
        /**
         * <p>
         * The name of the provider. This name is typically the company name.
         * </p>
         * 
         * @param providerName
         *        The name of the provider. This name is typically the company name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the product that the provider service provides.
         * </p>
         * 
         * @param providerServiceName
         *        The ARN (Amazon Resource Name) of the product that the provider service provides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerServiceName(String providerServiceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EntityResolutionRequest.BuilderImpl implements Builder {
        private String providerName;

        private String providerServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProviderServiceRequest model) {
            super(model);
            providerName(model.providerName);
            providerServiceName(model.providerServiceName);
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getProviderServiceName() {
            return providerServiceName;
        }

        public final void setProviderServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
        }

        @Override
        public final Builder providerServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProviderServiceRequest build() {
            return new GetProviderServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
