/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The record that didn't generate a Match ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedRecord implements SdkPojo, Serializable, ToCopyableBuilder<FailedRecord.Builder, FailedRecord> {
    private static final SdkField<String> INPUT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputSourceARN").getter(getter(FailedRecord::inputSourceARN)).setter(setter(Builder::inputSourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceARN").build()).build();

    private static final SdkField<String> UNIQUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uniqueId").getter(getter(FailedRecord::uniqueId)).setter(setter(Builder::uniqueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uniqueId").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(FailedRecord::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SOURCE_ARN_FIELD,
            UNIQUE_ID_FIELD, ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputSourceARN;

    private final String uniqueId;

    private final String errorMessage;

    private FailedRecord(BuilderImpl builder) {
        this.inputSourceARN = builder.inputSourceARN;
        this.uniqueId = builder.uniqueId;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The input source ARN of the record that didn't generate a Match ID.
     * </p>
     * 
     * @return The input source ARN of the record that didn't generate a Match ID.
     */
    public final String inputSourceARN() {
        return inputSourceARN;
    }

    /**
     * <p>
     * The unique ID of the record that didn't generate a Match ID.
     * </p>
     * 
     * @return The unique ID of the record that didn't generate a Match ID.
     */
    public final String uniqueId() {
        return uniqueId;
    }

    /**
     * <p>
     * The error message for the record that didn't generate a Match ID.
     * </p>
     * 
     * @return The error message for the record that didn't generate a Match ID.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputSourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueId());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedRecord)) {
            return false;
        }
        FailedRecord other = (FailedRecord) obj;
        return Objects.equals(inputSourceARN(), other.inputSourceARN()) && Objects.equals(uniqueId(), other.uniqueId())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedRecord").add("InputSourceARN", inputSourceARN()).add("UniqueId", uniqueId())
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputSourceARN":
            return Optional.ofNullable(clazz.cast(inputSourceARN()));
        case "uniqueId":
            return Optional.ofNullable(clazz.cast(uniqueId()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputSourceARN", INPUT_SOURCE_ARN_FIELD);
        map.put("uniqueId", UNIQUE_ID_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailedRecord, T> g) {
        return obj -> g.apply((FailedRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedRecord> {
        /**
         * <p>
         * The input source ARN of the record that didn't generate a Match ID.
         * </p>
         * 
         * @param inputSourceARN
         *        The input source ARN of the record that didn't generate a Match ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSourceARN(String inputSourceARN);

        /**
         * <p>
         * The unique ID of the record that didn't generate a Match ID.
         * </p>
         * 
         * @param uniqueId
         *        The unique ID of the record that didn't generate a Match ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueId(String uniqueId);

        /**
         * <p>
         * The error message for the record that didn't generate a Match ID.
         * </p>
         * 
         * @param errorMessage
         *        The error message for the record that didn't generate a Match ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String inputSourceARN;

        private String uniqueId;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedRecord model) {
            inputSourceARN(model.inputSourceARN);
            uniqueId(model.uniqueId);
            errorMessage(model.errorMessage);
        }

        public final String getInputSourceARN() {
            return inputSourceARN;
        }

        public final void setInputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
        }

        @Override
        public final Builder inputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
            return this;
        }

        public final String getUniqueId() {
            return uniqueId;
        }

        public final void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        @Override
        public final Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public FailedRecord build() {
            return new FailedRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
