/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProcessingType {
    CONSISTENT("CONSISTENT"),
    EVENTUAL("EVENTUAL"),
    EVENTUAL_NO_LOOKUP("EVENTUAL_NO_LOOKUP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProcessingType> VALUE_MAP;
    private final String value;

    private ProcessingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProcessingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProcessingType> knownValues() {
        EnumSet<ProcessingType> knownValues = EnumSet.allOf(ProcessingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProcessingType.class, ProcessingType::toString);
    }
}

