/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.entityresolution.model.RecordAttributeMapString255Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Record
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Record> {
    private static final SdkField<String> INPUT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputSourceARN").getter(Record.getter(Record::inputSourceARN)).setter(Record.setter(Builder::inputSourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceARN").build()}).build();
    private static final SdkField<String> UNIQUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uniqueId").getter(Record.getter(Record::uniqueId)).setter(Record.setter(Builder::uniqueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uniqueId").build()}).build();
    private static final SdkField<Map<String, String>> RECORD_ATTRIBUTE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("recordAttributeMap").getter(Record.getter(Record::recordAttributeMap)).setter(Record.setter(Builder::recordAttributeMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordAttributeMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SOURCE_ARN_FIELD, UNIQUE_ID_FIELD, RECORD_ATTRIBUTE_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Record.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String inputSourceARN;
    private final String uniqueId;
    private final Map<String, String> recordAttributeMap;

    private Record(BuilderImpl builder) {
        this.inputSourceARN = builder.inputSourceARN;
        this.uniqueId = builder.uniqueId;
        this.recordAttributeMap = builder.recordAttributeMap;
    }

    public final String inputSourceARN() {
        return this.inputSourceARN;
    }

    public final String uniqueId() {
        return this.uniqueId;
    }

    public final boolean hasRecordAttributeMap() {
        return this.recordAttributeMap != null && !(this.recordAttributeMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> recordAttributeMap() {
        return this.recordAttributeMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordAttributeMap() ? this.recordAttributeMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        return Objects.equals(this.inputSourceARN(), other.inputSourceARN()) && Objects.equals(this.uniqueId(), other.uniqueId()) && this.hasRecordAttributeMap() == other.hasRecordAttributeMap() && Objects.equals(this.recordAttributeMap(), other.recordAttributeMap());
    }

    public final String toString() {
        return ToString.builder((String)"Record").add("InputSourceARN", (Object)this.inputSourceARN()).add("UniqueId", (Object)this.uniqueId()).add("RecordAttributeMap", (Object)(this.recordAttributeMap() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputSourceARN": {
                return Optional.ofNullable(clazz.cast(this.inputSourceARN()));
            }
            case "uniqueId": {
                return Optional.ofNullable(clazz.cast(this.uniqueId()));
            }
            case "recordAttributeMap": {
                return Optional.ofNullable(clazz.cast(this.recordAttributeMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputSourceARN", INPUT_SOURCE_ARN_FIELD);
        map.put("uniqueId", UNIQUE_ID_FIELD);
        map.put("recordAttributeMap", RECORD_ATTRIBUTE_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Record, T> g) {
        return obj -> g.apply((Record)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputSourceARN;
        private String uniqueId;
        private Map<String, String> recordAttributeMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            this.inputSourceARN(model.inputSourceARN);
            this.uniqueId(model.uniqueId);
            this.recordAttributeMap(model.recordAttributeMap);
        }

        public final String getInputSourceARN() {
            return this.inputSourceARN;
        }

        public final void setInputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
        }

        @Override
        public final Builder inputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
            return this;
        }

        public final String getUniqueId() {
            return this.uniqueId;
        }

        public final void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        @Override
        public final Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public final Map<String, String> getRecordAttributeMap() {
            if (this.recordAttributeMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.recordAttributeMap;
        }

        public final void setRecordAttributeMap(Map<String, String> recordAttributeMap) {
            this.recordAttributeMap = RecordAttributeMapString255Copier.copy(recordAttributeMap);
        }

        @Override
        public final Builder recordAttributeMap(Map<String, String> recordAttributeMap) {
            this.recordAttributeMap = RecordAttributeMapString255Copier.copy(recordAttributeMap);
            return this;
        }

        public Record build() {
            return new Record(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Record> {
        public Builder inputSourceARN(String var1);

        public Builder uniqueId(String var1);

        public Builder recordAttributeMap(Map<String, String> var1);
    }
}

