/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.entityresolution.model.IdNamespaceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdMappingWorkflowInputSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdMappingWorkflowInputSource> {
    private static final SdkField<String> INPUT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputSourceARN").getter(IdMappingWorkflowInputSource.getter(IdMappingWorkflowInputSource::inputSourceARN)).setter(IdMappingWorkflowInputSource.setter(Builder::inputSourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceARN").build()}).build();
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaName").getter(IdMappingWorkflowInputSource.getter(IdMappingWorkflowInputSource::schemaName)).setter(IdMappingWorkflowInputSource.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(IdMappingWorkflowInputSource.getter(IdMappingWorkflowInputSource::typeAsString)).setter(IdMappingWorkflowInputSource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SOURCE_ARN_FIELD, SCHEMA_NAME_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IdMappingWorkflowInputSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String inputSourceARN;
    private final String schemaName;
    private final String type;

    private IdMappingWorkflowInputSource(BuilderImpl builder) {
        this.inputSourceARN = builder.inputSourceARN;
        this.schemaName = builder.schemaName;
        this.type = builder.type;
    }

    public final String inputSourceARN() {
        return this.inputSourceARN;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public final IdNamespaceType type() {
        return IdNamespaceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingWorkflowInputSource)) {
            return false;
        }
        IdMappingWorkflowInputSource other = (IdMappingWorkflowInputSource)obj;
        return Objects.equals(this.inputSourceARN(), other.inputSourceARN()) && Objects.equals(this.schemaName(), other.schemaName()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IdMappingWorkflowInputSource").add("InputSourceARN", (Object)this.inputSourceARN()).add("SchemaName", (Object)this.schemaName()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputSourceARN": {
                return Optional.ofNullable(clazz.cast(this.inputSourceARN()));
            }
            case "schemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("inputSourceARN", INPUT_SOURCE_ARN_FIELD);
        map.put("schemaName", SCHEMA_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdMappingWorkflowInputSource, T> g) {
        return obj -> g.apply((IdMappingWorkflowInputSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputSourceARN;
        private String schemaName;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingWorkflowInputSource model) {
            this.inputSourceARN(model.inputSourceARN);
            this.schemaName(model.schemaName);
            this.type(model.type);
        }

        public final String getInputSourceARN() {
            return this.inputSourceARN;
        }

        public final void setInputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
        }

        @Override
        public final Builder inputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
            return this;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IdNamespaceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public IdMappingWorkflowInputSource build() {
            return new IdMappingWorkflowInputSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdMappingWorkflowInputSource> {
        public Builder inputSourceARN(String var1);

        public Builder schemaName(String var1);

        public Builder type(String var1);

        public Builder type(IdNamespaceType var1);
    }
}

