/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionRequest;
import software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource;
import software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSourceConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartIdMappingJobRequest
extends EntityResolutionRequest
implements ToCopyableBuilder<Builder, StartIdMappingJobRequest> {
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowName").getter(StartIdMappingJobRequest.getter(StartIdMappingJobRequest::workflowName)).setter(StartIdMappingJobRequest.setter(Builder::workflowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowName").build()}).build();
    private static final SdkField<List<IdMappingJobOutputSource>> OUTPUT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputSourceConfig").getter(StartIdMappingJobRequest.getter(StartIdMappingJobRequest::outputSourceConfig)).setter(StartIdMappingJobRequest.setter(Builder::outputSourceConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSourceConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdMappingJobOutputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_NAME_FIELD, OUTPUT_SOURCE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartIdMappingJobRequest.memberNameToFieldInitializer();
    private final String workflowName;
    private final List<IdMappingJobOutputSource> outputSourceConfig;

    private StartIdMappingJobRequest(BuilderImpl builder) {
        super(builder);
        this.workflowName = builder.workflowName;
        this.outputSourceConfig = builder.outputSourceConfig;
    }

    public final String workflowName() {
        return this.workflowName;
    }

    public final boolean hasOutputSourceConfig() {
        return this.outputSourceConfig != null && !(this.outputSourceConfig instanceof SdkAutoConstructList);
    }

    public final List<IdMappingJobOutputSource> outputSourceConfig() {
        return this.outputSourceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputSourceConfig() ? this.outputSourceConfig() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartIdMappingJobRequest)) {
            return false;
        }
        StartIdMappingJobRequest other = (StartIdMappingJobRequest)((Object)obj);
        return Objects.equals(this.workflowName(), other.workflowName()) && this.hasOutputSourceConfig() == other.hasOutputSourceConfig() && Objects.equals(this.outputSourceConfig(), other.outputSourceConfig());
    }

    public final String toString() {
        return ToString.builder((String)"StartIdMappingJobRequest").add("WorkflowName", (Object)this.workflowName()).add("OutputSourceConfig", this.hasOutputSourceConfig() ? this.outputSourceConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowName": {
                return Optional.ofNullable(clazz.cast(this.workflowName()));
            }
            case "outputSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.outputSourceConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowName", WORKFLOW_NAME_FIELD);
        map.put("outputSourceConfig", OUTPUT_SOURCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartIdMappingJobRequest, T> g) {
        return obj -> g.apply((StartIdMappingJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionRequest.BuilderImpl
    implements Builder {
        private String workflowName;
        private List<IdMappingJobOutputSource> outputSourceConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartIdMappingJobRequest model) {
            super(model);
            this.workflowName(model.workflowName);
            this.outputSourceConfig(model.outputSourceConfig);
        }

        public final String getWorkflowName() {
            return this.workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final List<IdMappingJobOutputSource.Builder> getOutputSourceConfig() {
            List<IdMappingJobOutputSource.Builder> result = IdMappingJobOutputSourceConfigCopier.copyToBuilder(this.outputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSourceConfig(Collection<IdMappingJobOutputSource.BuilderImpl> outputSourceConfig) {
            this.outputSourceConfig = IdMappingJobOutputSourceConfigCopier.copyFromBuilder(outputSourceConfig);
        }

        @Override
        public final Builder outputSourceConfig(Collection<IdMappingJobOutputSource> outputSourceConfig) {
            this.outputSourceConfig = IdMappingJobOutputSourceConfigCopier.copy(outputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(IdMappingJobOutputSource ... outputSourceConfig) {
            this.outputSourceConfig(Arrays.asList(outputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(Consumer<IdMappingJobOutputSource.Builder> ... outputSourceConfig) {
            this.outputSourceConfig(Stream.of(outputSourceConfig).map(c -> (IdMappingJobOutputSource)((IdMappingJobOutputSource.Builder)IdMappingJobOutputSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartIdMappingJobRequest build() {
            return new StartIdMappingJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EntityResolutionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartIdMappingJobRequest> {
        public Builder workflowName(String var1);

        public Builder outputSourceConfig(Collection<IdMappingJobOutputSource> var1);

        public Builder outputSourceConfig(IdMappingJobOutputSource ... var1);

        public Builder outputSourceConfig(Consumer<IdMappingJobOutputSource.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

