/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputSource> {
    private static final SdkField<String> INPUT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputSourceARN").getter(InputSource.getter(InputSource::inputSourceARN)).setter(InputSource.setter(Builder::inputSourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceARN").build()}).build();
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaName").getter(InputSource.getter(InputSource::schemaName)).setter(InputSource.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()}).build();
    private static final SdkField<Boolean> APPLY_NORMALIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("applyNormalization").getter(InputSource.getter(InputSource::applyNormalization)).setter(InputSource.setter(Builder::applyNormalization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyNormalization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SOURCE_ARN_FIELD, SCHEMA_NAME_FIELD, APPLY_NORMALIZATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InputSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String inputSourceARN;
    private final String schemaName;
    private final Boolean applyNormalization;

    private InputSource(BuilderImpl builder) {
        this.inputSourceARN = builder.inputSourceARN;
        this.schemaName = builder.schemaName;
        this.applyNormalization = builder.applyNormalization;
    }

    public final String inputSourceARN() {
        return this.inputSourceARN;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public final Boolean applyNormalization() {
        return this.applyNormalization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyNormalization());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSource)) {
            return false;
        }
        InputSource other = (InputSource)obj;
        return Objects.equals(this.inputSourceARN(), other.inputSourceARN()) && Objects.equals(this.schemaName(), other.schemaName()) && Objects.equals(this.applyNormalization(), other.applyNormalization());
    }

    public final String toString() {
        return ToString.builder((String)"InputSource").add("InputSourceARN", (Object)this.inputSourceARN()).add("SchemaName", (Object)this.schemaName()).add("ApplyNormalization", (Object)this.applyNormalization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputSourceARN": {
                return Optional.ofNullable(clazz.cast(this.inputSourceARN()));
            }
            case "schemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "applyNormalization": {
                return Optional.ofNullable(clazz.cast(this.applyNormalization()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputSourceARN", INPUT_SOURCE_ARN_FIELD);
        map.put("schemaName", SCHEMA_NAME_FIELD);
        map.put("applyNormalization", APPLY_NORMALIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputSource, T> g) {
        return obj -> g.apply((InputSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputSourceARN;
        private String schemaName;
        private Boolean applyNormalization;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSource model) {
            this.inputSourceARN(model.inputSourceARN);
            this.schemaName(model.schemaName);
            this.applyNormalization(model.applyNormalization);
        }

        public final String getInputSourceARN() {
            return this.inputSourceARN;
        }

        public final void setInputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
        }

        @Override
        public final Builder inputSourceARN(String inputSourceARN) {
            this.inputSourceARN = inputSourceARN;
            return this;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final Boolean getApplyNormalization() {
            return this.applyNormalization;
        }

        public final void setApplyNormalization(Boolean applyNormalization) {
            this.applyNormalization = applyNormalization;
        }

        @Override
        public final Builder applyNormalization(Boolean applyNormalization) {
            this.applyNormalization = applyNormalization;
            return this;
        }

        public InputSource build() {
            return new InputSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputSource> {
        public Builder inputSourceARN(String var1);

        public Builder schemaName(String var1);

        public Builder applyNormalization(Boolean var1);
    }
}

