/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource;
import software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSourceConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartIdMappingJobResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, StartIdMappingJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(StartIdMappingJobResponse.getter(StartIdMappingJobResponse::jobId)).setter(StartIdMappingJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<List<IdMappingJobOutputSource>> OUTPUT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputSourceConfig").getter(StartIdMappingJobResponse.getter(StartIdMappingJobResponse::outputSourceConfig)).setter(StartIdMappingJobResponse.setter(Builder::outputSourceConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSourceConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdMappingJobOutputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, OUTPUT_SOURCE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartIdMappingJobResponse.memberNameToFieldInitializer();
    private final String jobId;
    private final List<IdMappingJobOutputSource> outputSourceConfig;

    private StartIdMappingJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.outputSourceConfig = builder.outputSourceConfig;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final boolean hasOutputSourceConfig() {
        return this.outputSourceConfig != null && !(this.outputSourceConfig instanceof SdkAutoConstructList);
    }

    public final List<IdMappingJobOutputSource> outputSourceConfig() {
        return this.outputSourceConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputSourceConfig() ? this.outputSourceConfig() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartIdMappingJobResponse)) {
            return false;
        }
        StartIdMappingJobResponse other = (StartIdMappingJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && this.hasOutputSourceConfig() == other.hasOutputSourceConfig() && Objects.equals(this.outputSourceConfig(), other.outputSourceConfig());
    }

    public final String toString() {
        return ToString.builder((String)"StartIdMappingJobResponse").add("JobId", (Object)this.jobId()).add("OutputSourceConfig", this.hasOutputSourceConfig() ? this.outputSourceConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "outputSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.outputSourceConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("outputSourceConfig", OUTPUT_SOURCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartIdMappingJobResponse, T> g) {
        return obj -> g.apply((StartIdMappingJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private List<IdMappingJobOutputSource> outputSourceConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartIdMappingJobResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.outputSourceConfig(model.outputSourceConfig);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final List<IdMappingJobOutputSource.Builder> getOutputSourceConfig() {
            List<IdMappingJobOutputSource.Builder> result = IdMappingJobOutputSourceConfigCopier.copyToBuilder(this.outputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSourceConfig(Collection<IdMappingJobOutputSource.BuilderImpl> outputSourceConfig) {
            this.outputSourceConfig = IdMappingJobOutputSourceConfigCopier.copyFromBuilder(outputSourceConfig);
        }

        @Override
        public final Builder outputSourceConfig(Collection<IdMappingJobOutputSource> outputSourceConfig) {
            this.outputSourceConfig = IdMappingJobOutputSourceConfigCopier.copy(outputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(IdMappingJobOutputSource ... outputSourceConfig) {
            this.outputSourceConfig(Arrays.asList(outputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(Consumer<IdMappingJobOutputSource.Builder> ... outputSourceConfig) {
            this.outputSourceConfig(Stream.of(outputSourceConfig).map(c -> (IdMappingJobOutputSource)((IdMappingJobOutputSource.Builder)IdMappingJobOutputSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public StartIdMappingJobResponse build() {
            return new StartIdMappingJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartIdMappingJobResponse> {
        public Builder jobId(String var1);

        public Builder outputSourceConfig(Collection<IdMappingJobOutputSource> var1);

        public Builder outputSourceConfig(IdMappingJobOutputSource ... var1);

        public Builder outputSourceConfig(Consumer<IdMappingJobOutputSource.Builder> ... var1);
    }
}

