/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.services.entityresolution.model.ProviderComponentSchema;
import software.amazon.awssdk.services.entityresolution.model.ProviderEndpointConfiguration;
import software.amazon.awssdk.services.entityresolution.model.ProviderIdNameSpaceConfiguration;
import software.amazon.awssdk.services.entityresolution.model.ProviderIntermediateDataAccessConfiguration;
import software.amazon.awssdk.services.entityresolution.model.ServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProviderServiceResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, GetProviderServiceResponse> {
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerName").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerName)).setter(GetProviderServiceResponse.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceName").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerServiceName)).setter(GetProviderServiceResponse.setter(Builder::providerServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceName").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceDisplayName").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerServiceDisplayName)).setter(GetProviderServiceResponse.setter(Builder::providerServiceDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceDisplayName").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceType").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerServiceTypeAsString)).setter(GetProviderServiceResponse.setter(Builder::providerServiceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceType").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceArn").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerServiceArn)).setter(GetProviderServiceResponse.setter(Builder::providerServiceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceArn").build()}).build();
    private static final SdkField<Document> PROVIDER_CONFIGURATION_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("providerConfigurationDefinition").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerConfigurationDefinition)).setter(GetProviderServiceResponse.setter(Builder::providerConfigurationDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerConfigurationDefinition").build()}).build();
    private static final SdkField<ProviderIdNameSpaceConfiguration> PROVIDER_ID_NAME_SPACE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("providerIdNameSpaceConfiguration").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerIdNameSpaceConfiguration)).setter(GetProviderServiceResponse.setter(Builder::providerIdNameSpaceConfiguration)).constructor(ProviderIdNameSpaceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerIdNameSpaceConfiguration").build()}).build();
    private static final SdkField<Document> PROVIDER_JOB_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("providerJobConfiguration").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerJobConfiguration)).setter(GetProviderServiceResponse.setter(Builder::providerJobConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerJobConfiguration").build()}).build();
    private static final SdkField<ProviderEndpointConfiguration> PROVIDER_ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("providerEndpointConfiguration").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerEndpointConfiguration)).setter(GetProviderServiceResponse.setter(Builder::providerEndpointConfiguration)).constructor(ProviderEndpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerEndpointConfiguration").build()}).build();
    private static final SdkField<Boolean> ANONYMIZED_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("anonymizedOutput").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::anonymizedOutput)).setter(GetProviderServiceResponse.setter(Builder::anonymizedOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anonymizedOutput").build()}).build();
    private static final SdkField<Document> PROVIDER_ENTITY_OUTPUT_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("providerEntityOutputDefinition").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerEntityOutputDefinition)).setter(GetProviderServiceResponse.setter(Builder::providerEntityOutputDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerEntityOutputDefinition").build()}).build();
    private static final SdkField<ProviderIntermediateDataAccessConfiguration> PROVIDER_INTERMEDIATE_DATA_ACCESS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("providerIntermediateDataAccessConfiguration").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerIntermediateDataAccessConfiguration)).setter(GetProviderServiceResponse.setter(Builder::providerIntermediateDataAccessConfiguration)).constructor(ProviderIntermediateDataAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerIntermediateDataAccessConfiguration").build()}).build();
    private static final SdkField<ProviderComponentSchema> PROVIDER_COMPONENT_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("providerComponentSchema").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerComponentSchema)).setter(GetProviderServiceResponse.setter(Builder::providerComponentSchema)).constructor(ProviderComponentSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerComponentSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NAME_FIELD, PROVIDER_SERVICE_NAME_FIELD, PROVIDER_SERVICE_DISPLAY_NAME_FIELD, PROVIDER_SERVICE_TYPE_FIELD, PROVIDER_SERVICE_ARN_FIELD, PROVIDER_CONFIGURATION_DEFINITION_FIELD, PROVIDER_ID_NAME_SPACE_CONFIGURATION_FIELD, PROVIDER_JOB_CONFIGURATION_FIELD, PROVIDER_ENDPOINT_CONFIGURATION_FIELD, ANONYMIZED_OUTPUT_FIELD, PROVIDER_ENTITY_OUTPUT_DEFINITION_FIELD, PROVIDER_INTERMEDIATE_DATA_ACCESS_CONFIGURATION_FIELD, PROVIDER_COMPONENT_SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetProviderServiceResponse.memberNameToFieldInitializer();
    private final String providerName;
    private final String providerServiceName;
    private final String providerServiceDisplayName;
    private final String providerServiceType;
    private final String providerServiceArn;
    private final Document providerConfigurationDefinition;
    private final ProviderIdNameSpaceConfiguration providerIdNameSpaceConfiguration;
    private final Document providerJobConfiguration;
    private final ProviderEndpointConfiguration providerEndpointConfiguration;
    private final Boolean anonymizedOutput;
    private final Document providerEntityOutputDefinition;
    private final ProviderIntermediateDataAccessConfiguration providerIntermediateDataAccessConfiguration;
    private final ProviderComponentSchema providerComponentSchema;

    private GetProviderServiceResponse(BuilderImpl builder) {
        super(builder);
        this.providerName = builder.providerName;
        this.providerServiceName = builder.providerServiceName;
        this.providerServiceDisplayName = builder.providerServiceDisplayName;
        this.providerServiceType = builder.providerServiceType;
        this.providerServiceArn = builder.providerServiceArn;
        this.providerConfigurationDefinition = builder.providerConfigurationDefinition;
        this.providerIdNameSpaceConfiguration = builder.providerIdNameSpaceConfiguration;
        this.providerJobConfiguration = builder.providerJobConfiguration;
        this.providerEndpointConfiguration = builder.providerEndpointConfiguration;
        this.anonymizedOutput = builder.anonymizedOutput;
        this.providerEntityOutputDefinition = builder.providerEntityOutputDefinition;
        this.providerIntermediateDataAccessConfiguration = builder.providerIntermediateDataAccessConfiguration;
        this.providerComponentSchema = builder.providerComponentSchema;
    }

    public final String providerName() {
        return this.providerName;
    }

    public final String providerServiceName() {
        return this.providerServiceName;
    }

    public final String providerServiceDisplayName() {
        return this.providerServiceDisplayName;
    }

    public final ServiceType providerServiceType() {
        return ServiceType.fromValue(this.providerServiceType);
    }

    public final String providerServiceTypeAsString() {
        return this.providerServiceType;
    }

    public final String providerServiceArn() {
        return this.providerServiceArn;
    }

    public final Document providerConfigurationDefinition() {
        return this.providerConfigurationDefinition;
    }

    public final ProviderIdNameSpaceConfiguration providerIdNameSpaceConfiguration() {
        return this.providerIdNameSpaceConfiguration;
    }

    public final Document providerJobConfiguration() {
        return this.providerJobConfiguration;
    }

    public final ProviderEndpointConfiguration providerEndpointConfiguration() {
        return this.providerEndpointConfiguration;
    }

    public final Boolean anonymizedOutput() {
        return this.anonymizedOutput;
    }

    public final Document providerEntityOutputDefinition() {
        return this.providerEntityOutputDefinition;
    }

    public final ProviderIntermediateDataAccessConfiguration providerIntermediateDataAccessConfiguration() {
        return this.providerIntermediateDataAccessConfiguration;
    }

    public final ProviderComponentSchema providerComponentSchema() {
        return this.providerComponentSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerConfigurationDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerIdNameSpaceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerJobConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerEndpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.anonymizedOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerEntityOutputDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerIntermediateDataAccessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerComponentSchema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProviderServiceResponse)) {
            return false;
        }
        GetProviderServiceResponse other = (GetProviderServiceResponse)((Object)obj);
        return Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.providerServiceName(), other.providerServiceName()) && Objects.equals(this.providerServiceDisplayName(), other.providerServiceDisplayName()) && Objects.equals(this.providerServiceTypeAsString(), other.providerServiceTypeAsString()) && Objects.equals(this.providerServiceArn(), other.providerServiceArn()) && Objects.equals(this.providerConfigurationDefinition(), other.providerConfigurationDefinition()) && Objects.equals(this.providerIdNameSpaceConfiguration(), other.providerIdNameSpaceConfiguration()) && Objects.equals(this.providerJobConfiguration(), other.providerJobConfiguration()) && Objects.equals(this.providerEndpointConfiguration(), other.providerEndpointConfiguration()) && Objects.equals(this.anonymizedOutput(), other.anonymizedOutput()) && Objects.equals(this.providerEntityOutputDefinition(), other.providerEntityOutputDefinition()) && Objects.equals(this.providerIntermediateDataAccessConfiguration(), other.providerIntermediateDataAccessConfiguration()) && Objects.equals(this.providerComponentSchema(), other.providerComponentSchema());
    }

    public final String toString() {
        return ToString.builder((String)"GetProviderServiceResponse").add("ProviderName", (Object)this.providerName()).add("ProviderServiceName", (Object)this.providerServiceName()).add("ProviderServiceDisplayName", (Object)this.providerServiceDisplayName()).add("ProviderServiceType", (Object)this.providerServiceTypeAsString()).add("ProviderServiceArn", (Object)this.providerServiceArn()).add("ProviderConfigurationDefinition", (Object)this.providerConfigurationDefinition()).add("ProviderIdNameSpaceConfiguration", (Object)this.providerIdNameSpaceConfiguration()).add("ProviderJobConfiguration", (Object)this.providerJobConfiguration()).add("ProviderEndpointConfiguration", (Object)this.providerEndpointConfiguration()).add("AnonymizedOutput", (Object)this.anonymizedOutput()).add("ProviderEntityOutputDefinition", (Object)this.providerEntityOutputDefinition()).add("ProviderIntermediateDataAccessConfiguration", (Object)this.providerIntermediateDataAccessConfiguration()).add("ProviderComponentSchema", (Object)this.providerComponentSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "providerServiceName": {
                return Optional.ofNullable(clazz.cast(this.providerServiceName()));
            }
            case "providerServiceDisplayName": {
                return Optional.ofNullable(clazz.cast(this.providerServiceDisplayName()));
            }
            case "providerServiceType": {
                return Optional.ofNullable(clazz.cast(this.providerServiceTypeAsString()));
            }
            case "providerServiceArn": {
                return Optional.ofNullable(clazz.cast(this.providerServiceArn()));
            }
            case "providerConfigurationDefinition": {
                return Optional.ofNullable(clazz.cast(this.providerConfigurationDefinition()));
            }
            case "providerIdNameSpaceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.providerIdNameSpaceConfiguration()));
            }
            case "providerJobConfiguration": {
                return Optional.ofNullable(clazz.cast(this.providerJobConfiguration()));
            }
            case "providerEndpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.providerEndpointConfiguration()));
            }
            case "anonymizedOutput": {
                return Optional.ofNullable(clazz.cast(this.anonymizedOutput()));
            }
            case "providerEntityOutputDefinition": {
                return Optional.ofNullable(clazz.cast(this.providerEntityOutputDefinition()));
            }
            case "providerIntermediateDataAccessConfiguration": {
                return Optional.ofNullable(clazz.cast(this.providerIntermediateDataAccessConfiguration()));
            }
            case "providerComponentSchema": {
                return Optional.ofNullable(clazz.cast(this.providerComponentSchema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("providerName", PROVIDER_NAME_FIELD);
        map.put("providerServiceName", PROVIDER_SERVICE_NAME_FIELD);
        map.put("providerServiceDisplayName", PROVIDER_SERVICE_DISPLAY_NAME_FIELD);
        map.put("providerServiceType", PROVIDER_SERVICE_TYPE_FIELD);
        map.put("providerServiceArn", PROVIDER_SERVICE_ARN_FIELD);
        map.put("providerConfigurationDefinition", PROVIDER_CONFIGURATION_DEFINITION_FIELD);
        map.put("providerIdNameSpaceConfiguration", PROVIDER_ID_NAME_SPACE_CONFIGURATION_FIELD);
        map.put("providerJobConfiguration", PROVIDER_JOB_CONFIGURATION_FIELD);
        map.put("providerEndpointConfiguration", PROVIDER_ENDPOINT_CONFIGURATION_FIELD);
        map.put("anonymizedOutput", ANONYMIZED_OUTPUT_FIELD);
        map.put("providerEntityOutputDefinition", PROVIDER_ENTITY_OUTPUT_DEFINITION_FIELD);
        map.put("providerIntermediateDataAccessConfiguration", PROVIDER_INTERMEDIATE_DATA_ACCESS_CONFIGURATION_FIELD);
        map.put("providerComponentSchema", PROVIDER_COMPONENT_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProviderServiceResponse, T> g) {
        return obj -> g.apply((GetProviderServiceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private String providerName;
        private String providerServiceName;
        private String providerServiceDisplayName;
        private String providerServiceType;
        private String providerServiceArn;
        private Document providerConfigurationDefinition;
        private ProviderIdNameSpaceConfiguration providerIdNameSpaceConfiguration;
        private Document providerJobConfiguration;
        private ProviderEndpointConfiguration providerEndpointConfiguration;
        private Boolean anonymizedOutput;
        private Document providerEntityOutputDefinition;
        private ProviderIntermediateDataAccessConfiguration providerIntermediateDataAccessConfiguration;
        private ProviderComponentSchema providerComponentSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProviderServiceResponse model) {
            super(model);
            this.providerName(model.providerName);
            this.providerServiceName(model.providerServiceName);
            this.providerServiceDisplayName(model.providerServiceDisplayName);
            this.providerServiceType(model.providerServiceType);
            this.providerServiceArn(model.providerServiceArn);
            this.providerConfigurationDefinition(model.providerConfigurationDefinition);
            this.providerIdNameSpaceConfiguration(model.providerIdNameSpaceConfiguration);
            this.providerJobConfiguration(model.providerJobConfiguration);
            this.providerEndpointConfiguration(model.providerEndpointConfiguration);
            this.anonymizedOutput(model.anonymizedOutput);
            this.providerEntityOutputDefinition(model.providerEntityOutputDefinition);
            this.providerIntermediateDataAccessConfiguration(model.providerIntermediateDataAccessConfiguration);
            this.providerComponentSchema(model.providerComponentSchema);
        }

        public final String getProviderName() {
            return this.providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getProviderServiceName() {
            return this.providerServiceName;
        }

        public final void setProviderServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
        }

        @Override
        public final Builder providerServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
            return this;
        }

        public final String getProviderServiceDisplayName() {
            return this.providerServiceDisplayName;
        }

        public final void setProviderServiceDisplayName(String providerServiceDisplayName) {
            this.providerServiceDisplayName = providerServiceDisplayName;
        }

        @Override
        public final Builder providerServiceDisplayName(String providerServiceDisplayName) {
            this.providerServiceDisplayName = providerServiceDisplayName;
            return this;
        }

        public final String getProviderServiceType() {
            return this.providerServiceType;
        }

        public final void setProviderServiceType(String providerServiceType) {
            this.providerServiceType = providerServiceType;
        }

        @Override
        public final Builder providerServiceType(String providerServiceType) {
            this.providerServiceType = providerServiceType;
            return this;
        }

        @Override
        public final Builder providerServiceType(ServiceType providerServiceType) {
            this.providerServiceType(providerServiceType == null ? null : providerServiceType.toString());
            return this;
        }

        public final String getProviderServiceArn() {
            return this.providerServiceArn;
        }

        public final void setProviderServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
        }

        @Override
        public final Builder providerServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
            return this;
        }

        public final Document getProviderConfigurationDefinition() {
            return this.providerConfigurationDefinition;
        }

        public final void setProviderConfigurationDefinition(Document providerConfigurationDefinition) {
            this.providerConfigurationDefinition = providerConfigurationDefinition;
        }

        @Override
        public final Builder providerConfigurationDefinition(Document providerConfigurationDefinition) {
            this.providerConfigurationDefinition = providerConfigurationDefinition;
            return this;
        }

        public final ProviderIdNameSpaceConfiguration.Builder getProviderIdNameSpaceConfiguration() {
            return this.providerIdNameSpaceConfiguration != null ? this.providerIdNameSpaceConfiguration.toBuilder() : null;
        }

        public final void setProviderIdNameSpaceConfiguration(ProviderIdNameSpaceConfiguration.BuilderImpl providerIdNameSpaceConfiguration) {
            this.providerIdNameSpaceConfiguration = providerIdNameSpaceConfiguration != null ? providerIdNameSpaceConfiguration.build() : null;
        }

        @Override
        public final Builder providerIdNameSpaceConfiguration(ProviderIdNameSpaceConfiguration providerIdNameSpaceConfiguration) {
            this.providerIdNameSpaceConfiguration = providerIdNameSpaceConfiguration;
            return this;
        }

        public final Document getProviderJobConfiguration() {
            return this.providerJobConfiguration;
        }

        public final void setProviderJobConfiguration(Document providerJobConfiguration) {
            this.providerJobConfiguration = providerJobConfiguration;
        }

        @Override
        public final Builder providerJobConfiguration(Document providerJobConfiguration) {
            this.providerJobConfiguration = providerJobConfiguration;
            return this;
        }

        public final ProviderEndpointConfiguration.Builder getProviderEndpointConfiguration() {
            return this.providerEndpointConfiguration != null ? this.providerEndpointConfiguration.toBuilder() : null;
        }

        public final void setProviderEndpointConfiguration(ProviderEndpointConfiguration.BuilderImpl providerEndpointConfiguration) {
            this.providerEndpointConfiguration = providerEndpointConfiguration != null ? providerEndpointConfiguration.build() : null;
        }

        @Override
        public final Builder providerEndpointConfiguration(ProviderEndpointConfiguration providerEndpointConfiguration) {
            this.providerEndpointConfiguration = providerEndpointConfiguration;
            return this;
        }

        public final Boolean getAnonymizedOutput() {
            return this.anonymizedOutput;
        }

        public final void setAnonymizedOutput(Boolean anonymizedOutput) {
            this.anonymizedOutput = anonymizedOutput;
        }

        @Override
        public final Builder anonymizedOutput(Boolean anonymizedOutput) {
            this.anonymizedOutput = anonymizedOutput;
            return this;
        }

        public final Document getProviderEntityOutputDefinition() {
            return this.providerEntityOutputDefinition;
        }

        public final void setProviderEntityOutputDefinition(Document providerEntityOutputDefinition) {
            this.providerEntityOutputDefinition = providerEntityOutputDefinition;
        }

        @Override
        public final Builder providerEntityOutputDefinition(Document providerEntityOutputDefinition) {
            this.providerEntityOutputDefinition = providerEntityOutputDefinition;
            return this;
        }

        public final ProviderIntermediateDataAccessConfiguration.Builder getProviderIntermediateDataAccessConfiguration() {
            return this.providerIntermediateDataAccessConfiguration != null ? this.providerIntermediateDataAccessConfiguration.toBuilder() : null;
        }

        public final void setProviderIntermediateDataAccessConfiguration(ProviderIntermediateDataAccessConfiguration.BuilderImpl providerIntermediateDataAccessConfiguration) {
            this.providerIntermediateDataAccessConfiguration = providerIntermediateDataAccessConfiguration != null ? providerIntermediateDataAccessConfiguration.build() : null;
        }

        @Override
        public final Builder providerIntermediateDataAccessConfiguration(ProviderIntermediateDataAccessConfiguration providerIntermediateDataAccessConfiguration) {
            this.providerIntermediateDataAccessConfiguration = providerIntermediateDataAccessConfiguration;
            return this;
        }

        public final ProviderComponentSchema.Builder getProviderComponentSchema() {
            return this.providerComponentSchema != null ? this.providerComponentSchema.toBuilder() : null;
        }

        public final void setProviderComponentSchema(ProviderComponentSchema.BuilderImpl providerComponentSchema) {
            this.providerComponentSchema = providerComponentSchema != null ? providerComponentSchema.build() : null;
        }

        @Override
        public final Builder providerComponentSchema(ProviderComponentSchema providerComponentSchema) {
            this.providerComponentSchema = providerComponentSchema;
            return this;
        }

        @Override
        public GetProviderServiceResponse build() {
            return new GetProviderServiceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProviderServiceResponse> {
        public Builder providerName(String var1);

        public Builder providerServiceName(String var1);

        public Builder providerServiceDisplayName(String var1);

        public Builder providerServiceType(String var1);

        public Builder providerServiceType(ServiceType var1);

        public Builder providerServiceArn(String var1);

        public Builder providerConfigurationDefinition(Document var1);

        public Builder providerIdNameSpaceConfiguration(ProviderIdNameSpaceConfiguration var1);

        default public Builder providerIdNameSpaceConfiguration(Consumer<ProviderIdNameSpaceConfiguration.Builder> providerIdNameSpaceConfiguration) {
            return this.providerIdNameSpaceConfiguration((ProviderIdNameSpaceConfiguration)((ProviderIdNameSpaceConfiguration.Builder)ProviderIdNameSpaceConfiguration.builder().applyMutation(providerIdNameSpaceConfiguration)).build());
        }

        public Builder providerJobConfiguration(Document var1);

        public Builder providerEndpointConfiguration(ProviderEndpointConfiguration var1);

        default public Builder providerEndpointConfiguration(Consumer<ProviderEndpointConfiguration.Builder> providerEndpointConfiguration) {
            return this.providerEndpointConfiguration((ProviderEndpointConfiguration)((ProviderEndpointConfiguration.Builder)ProviderEndpointConfiguration.builder().applyMutation(providerEndpointConfiguration)).build());
        }

        public Builder anonymizedOutput(Boolean var1);

        public Builder providerEntityOutputDefinition(Document var1);

        public Builder providerIntermediateDataAccessConfiguration(ProviderIntermediateDataAccessConfiguration var1);

        default public Builder providerIntermediateDataAccessConfiguration(Consumer<ProviderIntermediateDataAccessConfiguration.Builder> providerIntermediateDataAccessConfiguration) {
            return this.providerIntermediateDataAccessConfiguration((ProviderIntermediateDataAccessConfiguration)((ProviderIntermediateDataAccessConfiguration.Builder)ProviderIntermediateDataAccessConfiguration.builder().applyMutation(providerIntermediateDataAccessConfiguration)).build());
        }

        public Builder providerComponentSchema(ProviderComponentSchema var1);

        default public Builder providerComponentSchema(Consumer<ProviderComponentSchema.Builder> providerComponentSchema) {
            return this.providerComponentSchema((ProviderComponentSchema)((ProviderComponentSchema.Builder)ProviderComponentSchema.builder().applyMutation(providerComponentSchema)).build());
        }
    }
}

