/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.entityresolution.model.ProviderProperties;
import software.amazon.awssdk.services.entityresolution.model.ResolutionType;
import software.amazon.awssdk.services.entityresolution.model.RuleBasedProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolutionTechniques
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolutionTechniques> {
    private static final SdkField<String> RESOLUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolutionType").getter(ResolutionTechniques.getter(ResolutionTechniques::resolutionTypeAsString)).setter(ResolutionTechniques.setter(Builder::resolutionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionType").build()}).build();
    private static final SdkField<RuleBasedProperties> RULE_BASED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ruleBasedProperties").getter(ResolutionTechniques.getter(ResolutionTechniques::ruleBasedProperties)).setter(ResolutionTechniques.setter(Builder::ruleBasedProperties)).constructor(RuleBasedProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleBasedProperties").build()}).build();
    private static final SdkField<ProviderProperties> PROVIDER_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("providerProperties").getter(ResolutionTechniques.getter(ResolutionTechniques::providerProperties)).setter(ResolutionTechniques.setter(Builder::providerProperties)).constructor(ProviderProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLUTION_TYPE_FIELD, RULE_BASED_PROPERTIES_FIELD, PROVIDER_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResolutionTechniques.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resolutionType;
    private final RuleBasedProperties ruleBasedProperties;
    private final ProviderProperties providerProperties;

    private ResolutionTechniques(BuilderImpl builder) {
        this.resolutionType = builder.resolutionType;
        this.ruleBasedProperties = builder.ruleBasedProperties;
        this.providerProperties = builder.providerProperties;
    }

    public final ResolutionType resolutionType() {
        return ResolutionType.fromValue(this.resolutionType);
    }

    public final String resolutionTypeAsString() {
        return this.resolutionType;
    }

    public final RuleBasedProperties ruleBasedProperties() {
        return this.ruleBasedProperties;
    }

    public final ProviderProperties providerProperties() {
        return this.providerProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleBasedProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolutionTechniques)) {
            return false;
        }
        ResolutionTechniques other = (ResolutionTechniques)obj;
        return Objects.equals(this.resolutionTypeAsString(), other.resolutionTypeAsString()) && Objects.equals(this.ruleBasedProperties(), other.ruleBasedProperties()) && Objects.equals(this.providerProperties(), other.providerProperties());
    }

    public final String toString() {
        return ToString.builder((String)"ResolutionTechniques").add("ResolutionType", (Object)this.resolutionTypeAsString()).add("RuleBasedProperties", (Object)this.ruleBasedProperties()).add("ProviderProperties", (Object)this.providerProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resolutionType": {
                return Optional.ofNullable(clazz.cast(this.resolutionTypeAsString()));
            }
            case "ruleBasedProperties": {
                return Optional.ofNullable(clazz.cast(this.ruleBasedProperties()));
            }
            case "providerProperties": {
                return Optional.ofNullable(clazz.cast(this.providerProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resolutionType", RESOLUTION_TYPE_FIELD);
        map.put("ruleBasedProperties", RULE_BASED_PROPERTIES_FIELD);
        map.put("providerProperties", PROVIDER_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolutionTechniques, T> g) {
        return obj -> g.apply((ResolutionTechniques)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resolutionType;
        private RuleBasedProperties ruleBasedProperties;
        private ProviderProperties providerProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolutionTechniques model) {
            this.resolutionType(model.resolutionType);
            this.ruleBasedProperties(model.ruleBasedProperties);
            this.providerProperties(model.providerProperties);
        }

        public final String getResolutionType() {
            return this.resolutionType;
        }

        public final void setResolutionType(String resolutionType) {
            this.resolutionType = resolutionType;
        }

        @Override
        public final Builder resolutionType(String resolutionType) {
            this.resolutionType = resolutionType;
            return this;
        }

        @Override
        public final Builder resolutionType(ResolutionType resolutionType) {
            this.resolutionType(resolutionType == null ? null : resolutionType.toString());
            return this;
        }

        public final RuleBasedProperties.Builder getRuleBasedProperties() {
            return this.ruleBasedProperties != null ? this.ruleBasedProperties.toBuilder() : null;
        }

        public final void setRuleBasedProperties(RuleBasedProperties.BuilderImpl ruleBasedProperties) {
            this.ruleBasedProperties = ruleBasedProperties != null ? ruleBasedProperties.build() : null;
        }

        @Override
        public final Builder ruleBasedProperties(RuleBasedProperties ruleBasedProperties) {
            this.ruleBasedProperties = ruleBasedProperties;
            return this;
        }

        public final ProviderProperties.Builder getProviderProperties() {
            return this.providerProperties != null ? this.providerProperties.toBuilder() : null;
        }

        public final void setProviderProperties(ProviderProperties.BuilderImpl providerProperties) {
            this.providerProperties = providerProperties != null ? providerProperties.build() : null;
        }

        @Override
        public final Builder providerProperties(ProviderProperties providerProperties) {
            this.providerProperties = providerProperties;
            return this;
        }

        public ResolutionTechniques build() {
            return new ResolutionTechniques(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolutionTechniques> {
        public Builder resolutionType(String var1);

        public Builder resolutionType(ResolutionType var1);

        public Builder ruleBasedProperties(RuleBasedProperties var1);

        default public Builder ruleBasedProperties(Consumer<RuleBasedProperties.Builder> ruleBasedProperties) {
            return this.ruleBasedProperties((RuleBasedProperties)((RuleBasedProperties.Builder)RuleBasedProperties.builder().applyMutation(ruleBasedProperties)).build());
        }

        public Builder providerProperties(ProviderProperties var1);

        default public Builder providerProperties(Consumer<ProviderProperties.Builder> providerProperties) {
            return this.providerProperties((ProviderProperties)((ProviderProperties.Builder)ProviderProperties.builder().applyMutation(providerProperties)).build());
        }
    }
}

