/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionRequest;
import software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute;
import software.amazon.awssdk.services.entityresolution.model.SchemaInputAttributesCopier;
import software.amazon.awssdk.services.entityresolution.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSchemaMappingRequest
extends EntityResolutionRequest
implements ToCopyableBuilder<Builder, CreateSchemaMappingRequest> {
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaName").getter(CreateSchemaMappingRequest.getter(CreateSchemaMappingRequest::schemaName)).setter(CreateSchemaMappingRequest.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateSchemaMappingRequest.getter(CreateSchemaMappingRequest::description)).setter(CreateSchemaMappingRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<SchemaInputAttribute>> MAPPED_INPUT_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mappedInputFields").getter(CreateSchemaMappingRequest.getter(CreateSchemaMappingRequest::mappedInputFields)).setter(CreateSchemaMappingRequest.setter(Builder::mappedInputFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappedInputFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaInputAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSchemaMappingRequest.getter(CreateSchemaMappingRequest::tags)).setter(CreateSchemaMappingRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_NAME_FIELD, DESCRIPTION_FIELD, MAPPED_INPUT_FIELDS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSchemaMappingRequest.memberNameToFieldInitializer();
    private final String schemaName;
    private final String description;
    private final List<SchemaInputAttribute> mappedInputFields;
    private final Map<String, String> tags;

    private CreateSchemaMappingRequest(BuilderImpl builder) {
        super(builder);
        this.schemaName = builder.schemaName;
        this.description = builder.description;
        this.mappedInputFields = builder.mappedInputFields;
        this.tags = builder.tags;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasMappedInputFields() {
        return this.mappedInputFields != null && !(this.mappedInputFields instanceof SdkAutoConstructList);
    }

    public final List<SchemaInputAttribute> mappedInputFields() {
        return this.mappedInputFields;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMappedInputFields() ? this.mappedInputFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSchemaMappingRequest)) {
            return false;
        }
        CreateSchemaMappingRequest other = (CreateSchemaMappingRequest)((Object)obj);
        return Objects.equals(this.schemaName(), other.schemaName()) && Objects.equals(this.description(), other.description()) && this.hasMappedInputFields() == other.hasMappedInputFields() && Objects.equals(this.mappedInputFields(), other.mappedInputFields()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSchemaMappingRequest").add("SchemaName", (Object)this.schemaName()).add("Description", (Object)this.description()).add("MappedInputFields", this.hasMappedInputFields() ? this.mappedInputFields() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "mappedInputFields": {
                return Optional.ofNullable(clazz.cast(this.mappedInputFields()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("schemaName", SCHEMA_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("mappedInputFields", MAPPED_INPUT_FIELDS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSchemaMappingRequest, T> g) {
        return obj -> g.apply((CreateSchemaMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionRequest.BuilderImpl
    implements Builder {
        private String schemaName;
        private String description;
        private List<SchemaInputAttribute> mappedInputFields = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSchemaMappingRequest model) {
            super(model);
            this.schemaName(model.schemaName);
            this.description(model.description);
            this.mappedInputFields(model.mappedInputFields);
            this.tags(model.tags);
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SchemaInputAttribute.Builder> getMappedInputFields() {
            List<SchemaInputAttribute.Builder> result = SchemaInputAttributesCopier.copyToBuilder(this.mappedInputFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMappedInputFields(Collection<SchemaInputAttribute.BuilderImpl> mappedInputFields) {
            this.mappedInputFields = SchemaInputAttributesCopier.copyFromBuilder(mappedInputFields);
        }

        @Override
        public final Builder mappedInputFields(Collection<SchemaInputAttribute> mappedInputFields) {
            this.mappedInputFields = SchemaInputAttributesCopier.copy(mappedInputFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedInputFields(SchemaInputAttribute ... mappedInputFields) {
            this.mappedInputFields(Arrays.asList(mappedInputFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedInputFields(Consumer<SchemaInputAttribute.Builder> ... mappedInputFields) {
            this.mappedInputFields(Stream.of(mappedInputFields).map(c -> (SchemaInputAttribute)((SchemaInputAttribute.Builder)SchemaInputAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSchemaMappingRequest build() {
            return new CreateSchemaMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EntityResolutionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSchemaMappingRequest> {
        public Builder schemaName(String var1);

        public Builder description(String var1);

        public Builder mappedInputFields(Collection<SchemaInputAttribute> var1);

        public Builder mappedInputFields(SchemaInputAttribute ... var1);

        public Builder mappedInputFields(Consumer<SchemaInputAttribute.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

