/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.entityresolution.model.IntermediateSourceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProviderProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProviderProperties> {
    private static final SdkField<String> PROVIDER_SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceArn").getter(ProviderProperties.getter(ProviderProperties::providerServiceArn)).setter(ProviderProperties.setter(Builder::providerServiceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceArn").build()}).build();
    private static final SdkField<Document> PROVIDER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("providerConfiguration").getter(ProviderProperties.getter(ProviderProperties::providerConfiguration)).setter(ProviderProperties.setter(Builder::providerConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerConfiguration").build()}).build();
    private static final SdkField<IntermediateSourceConfiguration> INTERMEDIATE_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("intermediateSourceConfiguration").getter(ProviderProperties.getter(ProviderProperties::intermediateSourceConfiguration)).setter(ProviderProperties.setter(Builder::intermediateSourceConfiguration)).constructor(IntermediateSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intermediateSourceConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_SERVICE_ARN_FIELD, PROVIDER_CONFIGURATION_FIELD, INTERMEDIATE_SOURCE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProviderProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String providerServiceArn;
    private final Document providerConfiguration;
    private final IntermediateSourceConfiguration intermediateSourceConfiguration;

    private ProviderProperties(BuilderImpl builder) {
        this.providerServiceArn = builder.providerServiceArn;
        this.providerConfiguration = builder.providerConfiguration;
        this.intermediateSourceConfiguration = builder.intermediateSourceConfiguration;
    }

    public final String providerServiceArn() {
        return this.providerServiceArn;
    }

    public final Document providerConfiguration() {
        return this.providerConfiguration;
    }

    public final IntermediateSourceConfiguration intermediateSourceConfiguration() {
        return this.intermediateSourceConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.intermediateSourceConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderProperties)) {
            return false;
        }
        ProviderProperties other = (ProviderProperties)obj;
        return Objects.equals(this.providerServiceArn(), other.providerServiceArn()) && Objects.equals(this.providerConfiguration(), other.providerConfiguration()) && Objects.equals(this.intermediateSourceConfiguration(), other.intermediateSourceConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ProviderProperties").add("ProviderServiceArn", (Object)this.providerServiceArn()).add("ProviderConfiguration", (Object)this.providerConfiguration()).add("IntermediateSourceConfiguration", (Object)this.intermediateSourceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "providerServiceArn": {
                return Optional.ofNullable(clazz.cast(this.providerServiceArn()));
            }
            case "providerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.providerConfiguration()));
            }
            case "intermediateSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.intermediateSourceConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("providerServiceArn", PROVIDER_SERVICE_ARN_FIELD);
        map.put("providerConfiguration", PROVIDER_CONFIGURATION_FIELD);
        map.put("intermediateSourceConfiguration", INTERMEDIATE_SOURCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProviderProperties, T> g) {
        return obj -> g.apply((ProviderProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String providerServiceArn;
        private Document providerConfiguration;
        private IntermediateSourceConfiguration intermediateSourceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderProperties model) {
            this.providerServiceArn(model.providerServiceArn);
            this.providerConfiguration(model.providerConfiguration);
            this.intermediateSourceConfiguration(model.intermediateSourceConfiguration);
        }

        public final String getProviderServiceArn() {
            return this.providerServiceArn;
        }

        public final void setProviderServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
        }

        @Override
        public final Builder providerServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
            return this;
        }

        public final Document getProviderConfiguration() {
            return this.providerConfiguration;
        }

        public final void setProviderConfiguration(Document providerConfiguration) {
            this.providerConfiguration = providerConfiguration;
        }

        @Override
        public final Builder providerConfiguration(Document providerConfiguration) {
            this.providerConfiguration = providerConfiguration;
            return this;
        }

        public final IntermediateSourceConfiguration.Builder getIntermediateSourceConfiguration() {
            return this.intermediateSourceConfiguration != null ? this.intermediateSourceConfiguration.toBuilder() : null;
        }

        public final void setIntermediateSourceConfiguration(IntermediateSourceConfiguration.BuilderImpl intermediateSourceConfiguration) {
            this.intermediateSourceConfiguration = intermediateSourceConfiguration != null ? intermediateSourceConfiguration.build() : null;
        }

        @Override
        public final Builder intermediateSourceConfiguration(IntermediateSourceConfiguration intermediateSourceConfiguration) {
            this.intermediateSourceConfiguration = intermediateSourceConfiguration;
            return this;
        }

        public ProviderProperties build() {
            return new ProviderProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProviderProperties> {
        public Builder providerServiceArn(String var1);

        public Builder providerConfiguration(Document var1);

        public Builder intermediateSourceConfiguration(IntermediateSourceConfiguration var1);

        default public Builder intermediateSourceConfiguration(Consumer<IntermediateSourceConfiguration.Builder> intermediateSourceConfiguration) {
            return this.intermediateSourceConfiguration((IntermediateSourceConfiguration)((IntermediateSourceConfiguration.Builder)IntermediateSourceConfiguration.builder().applyMutation(intermediateSourceConfiguration)).build());
        }
    }
}

