/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdMappingWorkflowOutputSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdMappingWorkflowOutputSource> {
    private static final SdkField<String> OUTPUT_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputS3Path").getter(IdMappingWorkflowOutputSource.getter(IdMappingWorkflowOutputSource::outputS3Path)).setter(IdMappingWorkflowOutputSource.setter(Builder::outputS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Path").build()}).build();
    private static final SdkField<String> KMS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSArn").getter(IdMappingWorkflowOutputSource.getter(IdMappingWorkflowOutputSource::kmsArn)).setter(IdMappingWorkflowOutputSource.setter(Builder::kmsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_S3_PATH_FIELD, KMS_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IdMappingWorkflowOutputSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String outputS3Path;
    private final String kmsArn;

    private IdMappingWorkflowOutputSource(BuilderImpl builder) {
        this.outputS3Path = builder.outputS3Path;
        this.kmsArn = builder.kmsArn;
    }

    public final String outputS3Path() {
        return this.outputS3Path;
    }

    public final String kmsArn() {
        return this.kmsArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingWorkflowOutputSource)) {
            return false;
        }
        IdMappingWorkflowOutputSource other = (IdMappingWorkflowOutputSource)obj;
        return Objects.equals(this.outputS3Path(), other.outputS3Path()) && Objects.equals(this.kmsArn(), other.kmsArn());
    }

    public final String toString() {
        return ToString.builder((String)"IdMappingWorkflowOutputSource").add("OutputS3Path", (Object)this.outputS3Path()).add("KMSArn", (Object)this.kmsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outputS3Path": {
                return Optional.ofNullable(clazz.cast(this.outputS3Path()));
            }
            case "KMSArn": {
                return Optional.ofNullable(clazz.cast(this.kmsArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("outputS3Path", OUTPUT_S3_PATH_FIELD);
        map.put("KMSArn", KMS_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdMappingWorkflowOutputSource, T> g) {
        return obj -> g.apply((IdMappingWorkflowOutputSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputS3Path;
        private String kmsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingWorkflowOutputSource model) {
            this.outputS3Path(model.outputS3Path);
            this.kmsArn(model.kmsArn);
        }

        public final String getOutputS3Path() {
            return this.outputS3Path;
        }

        public final void setOutputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
        }

        @Override
        public final Builder outputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
            return this;
        }

        public final String getKmsArn() {
            return this.kmsArn;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public IdMappingWorkflowOutputSource build() {
            return new IdMappingWorkflowOutputSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdMappingWorkflowOutputSource> {
        public Builder outputS3Path(String var1);

        public Builder kmsArn(String var1);
    }
}

