/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.DeleteUniqueIdError;
import software.amazon.awssdk.services.entityresolution.model.DeleteUniqueIdErrorsListCopier;
import software.amazon.awssdk.services.entityresolution.model.DeleteUniqueIdStatus;
import software.amazon.awssdk.services.entityresolution.model.DeletedUniqueId;
import software.amazon.awssdk.services.entityresolution.model.DeletedUniqueIdListCopier;
import software.amazon.awssdk.services.entityresolution.model.DisconnectedUniqueIdsListCopier;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteUniqueIdResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, BatchDeleteUniqueIdResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(BatchDeleteUniqueIdResponse.getter(BatchDeleteUniqueIdResponse::statusAsString)).setter(BatchDeleteUniqueIdResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<DeleteUniqueIdError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchDeleteUniqueIdResponse.getter(BatchDeleteUniqueIdResponse::errors)).setter(BatchDeleteUniqueIdResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteUniqueIdError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DeletedUniqueId>> DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deleted").getter(BatchDeleteUniqueIdResponse.getter(BatchDeleteUniqueIdResponse::deleted)).setter(BatchDeleteUniqueIdResponse.setter(Builder::deleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleted").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeletedUniqueId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DISCONNECTED_UNIQUE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("disconnectedUniqueIds").getter(BatchDeleteUniqueIdResponse.getter(BatchDeleteUniqueIdResponse::disconnectedUniqueIds)).setter(BatchDeleteUniqueIdResponse.setter(Builder::disconnectedUniqueIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disconnectedUniqueIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ERRORS_FIELD, DELETED_FIELD, DISCONNECTED_UNIQUE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteUniqueIdResponse.memberNameToFieldInitializer();
    private final String status;
    private final List<DeleteUniqueIdError> errors;
    private final List<DeletedUniqueId> deleted;
    private final List<String> disconnectedUniqueIds;

    private BatchDeleteUniqueIdResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.errors = builder.errors;
        this.deleted = builder.deleted;
        this.disconnectedUniqueIds = builder.disconnectedUniqueIds;
    }

    public final DeleteUniqueIdStatus status() {
        return DeleteUniqueIdStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<DeleteUniqueIdError> errors() {
        return this.errors;
    }

    public final boolean hasDeleted() {
        return this.deleted != null && !(this.deleted instanceof SdkAutoConstructList);
    }

    public final List<DeletedUniqueId> deleted() {
        return this.deleted;
    }

    public final boolean hasDisconnectedUniqueIds() {
        return this.disconnectedUniqueIds != null && !(this.disconnectedUniqueIds instanceof SdkAutoConstructList);
    }

    public final List<String> disconnectedUniqueIds() {
        return this.disconnectedUniqueIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeleted() ? this.deleted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisconnectedUniqueIds() ? this.disconnectedUniqueIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteUniqueIdResponse)) {
            return false;
        }
        BatchDeleteUniqueIdResponse other = (BatchDeleteUniqueIdResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasDeleted() == other.hasDeleted() && Objects.equals(this.deleted(), other.deleted()) && this.hasDisconnectedUniqueIds() == other.hasDisconnectedUniqueIds() && Objects.equals(this.disconnectedUniqueIds(), other.disconnectedUniqueIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteUniqueIdResponse").add("Status", (Object)this.statusAsString()).add("Errors", this.hasErrors() ? this.errors() : null).add("Deleted", this.hasDeleted() ? this.deleted() : null).add("DisconnectedUniqueIds", this.hasDisconnectedUniqueIds() ? this.disconnectedUniqueIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "deleted": {
                return Optional.ofNullable(clazz.cast(this.deleted()));
            }
            case "disconnectedUniqueIds": {
                return Optional.ofNullable(clazz.cast(this.disconnectedUniqueIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("errors", ERRORS_FIELD);
        map.put("deleted", DELETED_FIELD);
        map.put("disconnectedUniqueIds", DISCONNECTED_UNIQUE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteUniqueIdResponse, T> g) {
        return obj -> g.apply((BatchDeleteUniqueIdResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private String status;
        private List<DeleteUniqueIdError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<DeletedUniqueId> deleted = DefaultSdkAutoConstructList.getInstance();
        private List<String> disconnectedUniqueIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteUniqueIdResponse model) {
            super(model);
            this.status(model.status);
            this.errors(model.errors);
            this.deleted(model.deleted);
            this.disconnectedUniqueIds(model.disconnectedUniqueIds);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeleteUniqueIdStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<DeleteUniqueIdError.Builder> getErrors() {
            List<DeleteUniqueIdError.Builder> result = DeleteUniqueIdErrorsListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<DeleteUniqueIdError.BuilderImpl> errors) {
            this.errors = DeleteUniqueIdErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<DeleteUniqueIdError> errors) {
            this.errors = DeleteUniqueIdErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(DeleteUniqueIdError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<DeleteUniqueIdError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (DeleteUniqueIdError)((DeleteUniqueIdError.Builder)DeleteUniqueIdError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DeletedUniqueId.Builder> getDeleted() {
            List<DeletedUniqueId.Builder> result = DeletedUniqueIdListCopier.copyToBuilder(this.deleted);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeleted(Collection<DeletedUniqueId.BuilderImpl> deleted) {
            this.deleted = DeletedUniqueIdListCopier.copyFromBuilder(deleted);
        }

        @Override
        public final Builder deleted(Collection<DeletedUniqueId> deleted) {
            this.deleted = DeletedUniqueIdListCopier.copy(deleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleted(DeletedUniqueId ... deleted) {
            this.deleted(Arrays.asList(deleted));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleted(Consumer<DeletedUniqueId.Builder> ... deleted) {
            this.deleted(Stream.of(deleted).map(c -> (DeletedUniqueId)((DeletedUniqueId.Builder)DeletedUniqueId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDisconnectedUniqueIds() {
            if (this.disconnectedUniqueIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.disconnectedUniqueIds;
        }

        public final void setDisconnectedUniqueIds(Collection<String> disconnectedUniqueIds) {
            this.disconnectedUniqueIds = DisconnectedUniqueIdsListCopier.copy(disconnectedUniqueIds);
        }

        @Override
        public final Builder disconnectedUniqueIds(Collection<String> disconnectedUniqueIds) {
            this.disconnectedUniqueIds = DisconnectedUniqueIdsListCopier.copy(disconnectedUniqueIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disconnectedUniqueIds(String ... disconnectedUniqueIds) {
            this.disconnectedUniqueIds(Arrays.asList(disconnectedUniqueIds));
            return this;
        }

        @Override
        public BatchDeleteUniqueIdResponse build() {
            return new BatchDeleteUniqueIdResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteUniqueIdResponse> {
        public Builder status(String var1);

        public Builder status(DeleteUniqueIdStatus var1);

        public Builder errors(Collection<DeleteUniqueIdError> var1);

        public Builder errors(DeleteUniqueIdError ... var1);

        public Builder errors(Consumer<DeleteUniqueIdError.Builder> ... var1);

        public Builder deleted(Collection<DeletedUniqueId> var1);

        public Builder deleted(DeletedUniqueId ... var1);

        public Builder deleted(Consumer<DeletedUniqueId.Builder> ... var1);

        public Builder disconnectedUniqueIds(Collection<String> var1);

        public Builder disconnectedUniqueIds(String ... var1);
    }
}

