/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute;
import software.amazon.awssdk.services.entityresolution.model.SchemaInputAttributesCopier;
import software.amazon.awssdk.services.entityresolution.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSchemaMappingResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, GetSchemaMappingResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetSchemaMappingResponse.getter(GetSchemaMappingResponse::createdAt)).setter(GetSchemaMappingResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetSchemaMappingResponse.getter(GetSchemaMappingResponse::description)).setter(GetSchemaMappingResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> HAS_WORKFLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("hasWorkflows").getter(GetSchemaMappingResponse.getter(GetSchemaMappingResponse::hasWorkflows)).setter(GetSchemaMappingResponse.setter(Builder::hasWorkflows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasWorkflows").build()}).build();
    private static final SdkField<List<SchemaInputAttribute>> MAPPED_INPUT_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mappedInputFields").getter(GetSchemaMappingResponse.getter(GetSchemaMappingResponse::mappedInputFields)).setter(GetSchemaMappingResponse.setter(Builder::mappedInputFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappedInputFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaInputAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaArn").getter(GetSchemaMappingResponse.getter(GetSchemaMappingResponse::schemaArn)).setter(GetSchemaMappingResponse.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaArn").build()}).build();
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaName").getter(GetSchemaMappingResponse.getter(GetSchemaMappingResponse::schemaName)).setter(GetSchemaMappingResponse.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetSchemaMappingResponse.getter(GetSchemaMappingResponse::tags)).setter(GetSchemaMappingResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetSchemaMappingResponse.getter(GetSchemaMappingResponse::updatedAt)).setter(GetSchemaMappingResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DESCRIPTION_FIELD, HAS_WORKFLOWS_FIELD, MAPPED_INPUT_FIELDS_FIELD, SCHEMA_ARN_FIELD, SCHEMA_NAME_FIELD, TAGS_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("hasWorkflows", HAS_WORKFLOWS_FIELD);
            this.put("mappedInputFields", MAPPED_INPUT_FIELDS_FIELD);
            this.put("schemaArn", SCHEMA_ARN_FIELD);
            this.put("schemaName", SCHEMA_NAME_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
        }
    });
    private final Instant createdAt;
    private final String description;
    private final Boolean hasWorkflows;
    private final List<SchemaInputAttribute> mappedInputFields;
    private final String schemaArn;
    private final String schemaName;
    private final Map<String, String> tags;
    private final Instant updatedAt;

    private GetSchemaMappingResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.hasWorkflows = builder.hasWorkflows;
        this.mappedInputFields = builder.mappedInputFields;
        this.schemaArn = builder.schemaArn;
        this.schemaName = builder.schemaName;
        this.tags = builder.tags;
        this.updatedAt = builder.updatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean hasWorkflows() {
        return this.hasWorkflows;
    }

    public final boolean hasMappedInputFields() {
        return this.mappedInputFields != null && !(this.mappedInputFields instanceof SdkAutoConstructList);
    }

    public final List<SchemaInputAttribute> mappedInputFields() {
        return this.mappedInputFields;
    }

    public final String schemaArn() {
        return this.schemaArn;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflows());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMappedInputFields() ? this.mappedInputFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaMappingResponse)) {
            return false;
        }
        GetSchemaMappingResponse other = (GetSchemaMappingResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.hasWorkflows(), other.hasWorkflows()) && this.hasMappedInputFields() == other.hasMappedInputFields() && Objects.equals(this.mappedInputFields(), other.mappedInputFields()) && Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.schemaName(), other.schemaName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetSchemaMappingResponse").add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("HasWorkflows", (Object)this.hasWorkflows()).add("MappedInputFields", this.hasMappedInputFields() ? this.mappedInputFields() : null).add("SchemaArn", (Object)this.schemaArn()).add("SchemaName", (Object)this.schemaName()).add("Tags", this.hasTags() ? this.tags() : null).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "hasWorkflows": {
                return Optional.ofNullable(clazz.cast(this.hasWorkflows()));
            }
            case "mappedInputFields": {
                return Optional.ofNullable(clazz.cast(this.mappedInputFields()));
            }
            case "schemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "schemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaMappingResponse, T> g) {
        return obj -> g.apply((GetSchemaMappingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String description;
        private Boolean hasWorkflows;
        private List<SchemaInputAttribute> mappedInputFields = DefaultSdkAutoConstructList.getInstance();
        private String schemaArn;
        private String schemaName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaMappingResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.hasWorkflows(model.hasWorkflows);
            this.mappedInputFields(model.mappedInputFields);
            this.schemaArn(model.schemaArn);
            this.schemaName(model.schemaName);
            this.tags(model.tags);
            this.updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getHasWorkflows() {
            return this.hasWorkflows;
        }

        public final void setHasWorkflows(Boolean hasWorkflows) {
            this.hasWorkflows = hasWorkflows;
        }

        @Override
        public final Builder hasWorkflows(Boolean hasWorkflows) {
            this.hasWorkflows = hasWorkflows;
            return this;
        }

        public final List<SchemaInputAttribute.Builder> getMappedInputFields() {
            List<SchemaInputAttribute.Builder> result = SchemaInputAttributesCopier.copyToBuilder(this.mappedInputFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMappedInputFields(Collection<SchemaInputAttribute.BuilderImpl> mappedInputFields) {
            this.mappedInputFields = SchemaInputAttributesCopier.copyFromBuilder(mappedInputFields);
        }

        @Override
        public final Builder mappedInputFields(Collection<SchemaInputAttribute> mappedInputFields) {
            this.mappedInputFields = SchemaInputAttributesCopier.copy(mappedInputFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedInputFields(SchemaInputAttribute ... mappedInputFields) {
            this.mappedInputFields(Arrays.asList(mappedInputFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedInputFields(Consumer<SchemaInputAttribute.Builder> ... mappedInputFields) {
            this.mappedInputFields(Stream.of(mappedInputFields).map(c -> (SchemaInputAttribute)((SchemaInputAttribute.Builder)SchemaInputAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetSchemaMappingResponse build() {
            return new GetSchemaMappingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSchemaMappingResponse> {
        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder hasWorkflows(Boolean var1);

        public Builder mappedInputFields(Collection<SchemaInputAttribute> var1);

        public Builder mappedInputFields(SchemaInputAttribute ... var1);

        public Builder mappedInputFields(Consumer<SchemaInputAttribute.Builder> ... var1);

        public Builder schemaArn(String var1);

        public Builder schemaName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder updatedAt(Instant var1);
    }
}

