/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IdMappingType {
    PROVIDER("PROVIDER"),
    RULE_BASED("RULE_BASED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IdMappingType> VALUE_MAP;
    private final String value;

    private IdMappingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IdMappingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IdMappingType> knownValues() {
        EnumSet<IdMappingType> knownValues = EnumSet.allOf(IdMappingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IdMappingType.class, IdMappingType::toString);
    }
}

