/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionAsyncClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.IdNamespaceSummary;
import software.amazon.awssdk.services.entityresolution.model.ListIdNamespacesRequest;
import software.amazon.awssdk.services.entityresolution.model.ListIdNamespacesResponse;

public class ListIdNamespacesPublisher
implements SdkPublisher<ListIdNamespacesResponse> {
    private final EntityResolutionAsyncClient client;
    private final ListIdNamespacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIdNamespacesPublisher(EntityResolutionAsyncClient client, ListIdNamespacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIdNamespacesPublisher(EntityResolutionAsyncClient client, ListIdNamespacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIdNamespacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIdNamespacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IdNamespaceSummary> idNamespaceSummaries() {
        Function<ListIdNamespacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.idNamespaceSummaries() != null) {
                return response.idNamespaceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIdNamespacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIdNamespacesResponseFetcher
    implements AsyncPageFetcher<ListIdNamespacesResponse> {
        private ListIdNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListIdNamespacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIdNamespacesResponse> nextPage(ListIdNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListIdNamespacesPublisher.this.client.listIdNamespaces(ListIdNamespacesPublisher.this.firstRequest);
            }
            return ListIdNamespacesPublisher.this.client.listIdNamespaces((ListIdNamespacesRequest)((Object)ListIdNamespacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

