/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionRequest;
import software.amazon.awssdk.services.entityresolution.model.StatementActionListCopier;
import software.amazon.awssdk.services.entityresolution.model.StatementEffect;
import software.amazon.awssdk.services.entityresolution.model.StatementPrincipalListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddPolicyStatementRequest
extends EntityResolutionRequest
implements ToCopyableBuilder<Builder, AddPolicyStatementRequest> {
    private static final SdkField<List<String>> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("action").getter(AddPolicyStatementRequest.getter(AddPolicyStatementRequest::action)).setter(AddPolicyStatementRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(AddPolicyStatementRequest.getter(AddPolicyStatementRequest::arn)).setter(AddPolicyStatementRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("arn").build()}).build();
    private static final SdkField<String> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("condition").getter(AddPolicyStatementRequest.getter(AddPolicyStatementRequest::condition)).setter(AddPolicyStatementRequest.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()}).build();
    private static final SdkField<String> EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("effect").getter(AddPolicyStatementRequest.getter(AddPolicyStatementRequest::effectAsString)).setter(AddPolicyStatementRequest.setter(Builder::effect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effect").build()}).build();
    private static final SdkField<List<String>> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("principal").getter(AddPolicyStatementRequest.getter(AddPolicyStatementRequest::principal)).setter(AddPolicyStatementRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statementId").getter(AddPolicyStatementRequest.getter(AddPolicyStatementRequest::statementId)).setter(AddPolicyStatementRequest.setter(Builder::statementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("statementId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ARN_FIELD, CONDITION_FIELD, EFFECT_FIELD, PRINCIPAL_FIELD, STATEMENT_ID_FIELD));
    private final List<String> action;
    private final String arn;
    private final String condition;
    private final String effect;
    private final List<String> principal;
    private final String statementId;

    private AddPolicyStatementRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.arn = builder.arn;
        this.condition = builder.condition;
        this.effect = builder.effect;
        this.principal = builder.principal;
        this.statementId = builder.statementId;
    }

    public final boolean hasAction() {
        return this.action != null && !(this.action instanceof SdkAutoConstructList);
    }

    public final List<String> action() {
        return this.action;
    }

    public final String arn() {
        return this.arn;
    }

    public final String condition() {
        return this.condition;
    }

    public final StatementEffect effect() {
        return StatementEffect.fromValue(this.effect);
    }

    public final String effectAsString() {
        return this.effect;
    }

    public final boolean hasPrincipal() {
        return this.principal != null && !(this.principal instanceof SdkAutoConstructList);
    }

    public final List<String> principal() {
        return this.principal;
    }

    public final String statementId() {
        return this.statementId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAction() ? this.action() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipal() ? this.principal() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statementId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPolicyStatementRequest)) {
            return false;
        }
        AddPolicyStatementRequest other = (AddPolicyStatementRequest)((Object)obj);
        return this.hasAction() == other.hasAction() && Objects.equals(this.action(), other.action()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.condition(), other.condition()) && Objects.equals(this.effectAsString(), other.effectAsString()) && this.hasPrincipal() == other.hasPrincipal() && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.statementId(), other.statementId());
    }

    public final String toString() {
        return ToString.builder((String)"AddPolicyStatementRequest").add("Action", this.hasAction() ? this.action() : null).add("Arn", (Object)this.arn()).add("Condition", (Object)this.condition()).add("Effect", (Object)this.effectAsString()).add("Principal", this.hasPrincipal() ? this.principal() : null).add("StatementId", (Object)this.statementId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "effect": {
                return Optional.ofNullable(clazz.cast(this.effectAsString()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "statementId": {
                return Optional.ofNullable(clazz.cast(this.statementId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddPolicyStatementRequest, T> g) {
        return obj -> g.apply((AddPolicyStatementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionRequest.BuilderImpl
    implements Builder {
        private List<String> action = DefaultSdkAutoConstructList.getInstance();
        private String arn;
        private String condition;
        private String effect;
        private List<String> principal = DefaultSdkAutoConstructList.getInstance();
        private String statementId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddPolicyStatementRequest model) {
            super(model);
            this.action(model.action);
            this.arn(model.arn);
            this.condition(model.condition);
            this.effect(model.effect);
            this.principal(model.principal);
            this.statementId(model.statementId);
        }

        public final Collection<String> getAction() {
            if (this.action instanceof SdkAutoConstructList) {
                return null;
            }
            return this.action;
        }

        public final void setAction(Collection<String> action) {
            this.action = StatementActionListCopier.copy(action);
        }

        @Override
        public final Builder action(Collection<String> action) {
            this.action = StatementActionListCopier.copy(action);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder action(String ... action) {
            this.action(Arrays.asList(action));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCondition() {
            return this.condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public final String getEffect() {
            return this.effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(StatementEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final Collection<String> getPrincipal() {
            if (this.principal instanceof SdkAutoConstructList) {
                return null;
            }
            return this.principal;
        }

        public final void setPrincipal(Collection<String> principal) {
            this.principal = StatementPrincipalListCopier.copy(principal);
        }

        @Override
        public final Builder principal(Collection<String> principal) {
            this.principal = StatementPrincipalListCopier.copy(principal);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principal(String ... principal) {
            this.principal(Arrays.asList(principal));
            return this;
        }

        public final String getStatementId() {
            return this.statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddPolicyStatementRequest build() {
            return new AddPolicyStatementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EntityResolutionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddPolicyStatementRequest> {
        public Builder action(Collection<String> var1);

        public Builder action(String ... var1);

        public Builder arn(String var1);

        public Builder condition(String var1);

        public Builder effect(String var1);

        public Builder effect(StatementEffect var1);

        public Builder principal(Collection<String> var1);

        public Builder principal(String ... var1);

        public Builder statementId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

