/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionAsyncClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.JobSummary;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsResponse;

public class ListIdMappingJobsPublisher
implements SdkPublisher<ListIdMappingJobsResponse> {
    private final EntityResolutionAsyncClient client;
    private final ListIdMappingJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIdMappingJobsPublisher(EntityResolutionAsyncClient client, ListIdMappingJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIdMappingJobsPublisher(EntityResolutionAsyncClient client, ListIdMappingJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIdMappingJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIdMappingJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobSummary> jobs() {
        Function<ListIdMappingJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIdMappingJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIdMappingJobsResponseFetcher
    implements AsyncPageFetcher<ListIdMappingJobsResponse> {
        private ListIdMappingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListIdMappingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIdMappingJobsResponse> nextPage(ListIdMappingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListIdMappingJobsPublisher.this.client.listIdMappingJobs(ListIdMappingJobsPublisher.this.firstRequest);
            }
            return ListIdMappingJobsPublisher.this.client.listIdMappingJobs((ListIdMappingJobsRequest)((Object)ListIdMappingJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

