/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration setting for monitoring.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringConfiguration.Builder, MonitoringConfiguration> {
    private static final SdkField<S3MonitoringConfiguration> S3_MONITORING_CONFIGURATION_FIELD = SdkField
            .<S3MonitoringConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3MonitoringConfiguration")
            .getter(getter(MonitoringConfiguration::s3MonitoringConfiguration))
            .setter(setter(Builder::s3MonitoringConfiguration)).constructor(S3MonitoringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3MonitoringConfiguration").build())
            .build();

    private static final SdkField<ManagedPersistenceMonitoringConfiguration> MANAGED_PERSISTENCE_MONITORING_CONFIGURATION_FIELD = SdkField
            .<ManagedPersistenceMonitoringConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("managedPersistenceMonitoringConfiguration")
            .getter(getter(MonitoringConfiguration::managedPersistenceMonitoringConfiguration))
            .setter(setter(Builder::managedPersistenceMonitoringConfiguration))
            .constructor(ManagedPersistenceMonitoringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("managedPersistenceMonitoringConfiguration").build()).build();

    private static final SdkField<CloudWatchLoggingConfiguration> CLOUD_WATCH_LOGGING_CONFIGURATION_FIELD = SdkField
            .<CloudWatchLoggingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("cloudWatchLoggingConfiguration")
            .getter(getter(MonitoringConfiguration::cloudWatchLoggingConfiguration))
            .setter(setter(Builder::cloudWatchLoggingConfiguration))
            .constructor(CloudWatchLoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLoggingConfiguration")
                    .build()).build();

    private static final SdkField<PrometheusMonitoringConfiguration> PROMETHEUS_MONITORING_CONFIGURATION_FIELD = SdkField
            .<PrometheusMonitoringConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("prometheusMonitoringConfiguration")
            .getter(getter(MonitoringConfiguration::prometheusMonitoringConfiguration))
            .setter(setter(Builder::prometheusMonitoringConfiguration))
            .constructor(PrometheusMonitoringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prometheusMonitoringConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            S3_MONITORING_CONFIGURATION_FIELD, MANAGED_PERSISTENCE_MONITORING_CONFIGURATION_FIELD,
            CLOUD_WATCH_LOGGING_CONFIGURATION_FIELD, PROMETHEUS_MONITORING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3MonitoringConfiguration s3MonitoringConfiguration;

    private final ManagedPersistenceMonitoringConfiguration managedPersistenceMonitoringConfiguration;

    private final CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration;

    private final PrometheusMonitoringConfiguration prometheusMonitoringConfiguration;

    private MonitoringConfiguration(BuilderImpl builder) {
        this.s3MonitoringConfiguration = builder.s3MonitoringConfiguration;
        this.managedPersistenceMonitoringConfiguration = builder.managedPersistenceMonitoringConfiguration;
        this.cloudWatchLoggingConfiguration = builder.cloudWatchLoggingConfiguration;
        this.prometheusMonitoringConfiguration = builder.prometheusMonitoringConfiguration;
    }

    /**
     * <p>
     * The Amazon S3 configuration for monitoring log publishing.
     * </p>
     * 
     * @return The Amazon S3 configuration for monitoring log publishing.
     */
    public final S3MonitoringConfiguration s3MonitoringConfiguration() {
        return s3MonitoringConfiguration;
    }

    /**
     * <p>
     * The managed log persistence configuration for a job run.
     * </p>
     * 
     * @return The managed log persistence configuration for a job run.
     */
    public final ManagedPersistenceMonitoringConfiguration managedPersistenceMonitoringConfiguration() {
        return managedPersistenceMonitoringConfiguration;
    }

    /**
     * <p>
     * The Amazon CloudWatch configuration for monitoring logs. You can configure your jobs to send log information to
     * CloudWatch.
     * </p>
     * 
     * @return The Amazon CloudWatch configuration for monitoring logs. You can configure your jobs to send log
     *         information to CloudWatch.
     */
    public final CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration() {
        return cloudWatchLoggingConfiguration;
    }

    /**
     * <p>
     * The monitoring configuration object you can configure to send metrics to Amazon Managed Service for Prometheus
     * for a job run.
     * </p>
     * 
     * @return The monitoring configuration object you can configure to send metrics to Amazon Managed Service for
     *         Prometheus for a job run.
     */
    public final PrometheusMonitoringConfiguration prometheusMonitoringConfiguration() {
        return prometheusMonitoringConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3MonitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(managedPersistenceMonitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(prometheusMonitoringConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringConfiguration)) {
            return false;
        }
        MonitoringConfiguration other = (MonitoringConfiguration) obj;
        return Objects.equals(s3MonitoringConfiguration(), other.s3MonitoringConfiguration())
                && Objects.equals(managedPersistenceMonitoringConfiguration(), other.managedPersistenceMonitoringConfiguration())
                && Objects.equals(cloudWatchLoggingConfiguration(), other.cloudWatchLoggingConfiguration())
                && Objects.equals(prometheusMonitoringConfiguration(), other.prometheusMonitoringConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringConfiguration").add("S3MonitoringConfiguration", s3MonitoringConfiguration())
                .add("ManagedPersistenceMonitoringConfiguration", managedPersistenceMonitoringConfiguration())
                .add("CloudWatchLoggingConfiguration", cloudWatchLoggingConfiguration())
                .add("PrometheusMonitoringConfiguration", prometheusMonitoringConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3MonitoringConfiguration":
            return Optional.ofNullable(clazz.cast(s3MonitoringConfiguration()));
        case "managedPersistenceMonitoringConfiguration":
            return Optional.ofNullable(clazz.cast(managedPersistenceMonitoringConfiguration()));
        case "cloudWatchLoggingConfiguration":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingConfiguration()));
        case "prometheusMonitoringConfiguration":
            return Optional.ofNullable(clazz.cast(prometheusMonitoringConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3MonitoringConfiguration", S3_MONITORING_CONFIGURATION_FIELD);
        map.put("managedPersistenceMonitoringConfiguration", MANAGED_PERSISTENCE_MONITORING_CONFIGURATION_FIELD);
        map.put("cloudWatchLoggingConfiguration", CLOUD_WATCH_LOGGING_CONFIGURATION_FIELD);
        map.put("prometheusMonitoringConfiguration", PROMETHEUS_MONITORING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringConfiguration, T> g) {
        return obj -> g.apply((MonitoringConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringConfiguration> {
        /**
         * <p>
         * The Amazon S3 configuration for monitoring log publishing.
         * </p>
         * 
         * @param s3MonitoringConfiguration
         *        The Amazon S3 configuration for monitoring log publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3MonitoringConfiguration(S3MonitoringConfiguration s3MonitoringConfiguration);

        /**
         * <p>
         * The Amazon S3 configuration for monitoring log publishing.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3MonitoringConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3MonitoringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3MonitoringConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3MonitoringConfiguration(S3MonitoringConfiguration)}.
         * 
         * @param s3MonitoringConfiguration
         *        a consumer that will call methods on {@link S3MonitoringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3MonitoringConfiguration(S3MonitoringConfiguration)
         */
        default Builder s3MonitoringConfiguration(Consumer<S3MonitoringConfiguration.Builder> s3MonitoringConfiguration) {
            return s3MonitoringConfiguration(S3MonitoringConfiguration.builder().applyMutation(s3MonitoringConfiguration).build());
        }

        /**
         * <p>
         * The managed log persistence configuration for a job run.
         * </p>
         * 
         * @param managedPersistenceMonitoringConfiguration
         *        The managed log persistence configuration for a job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedPersistenceMonitoringConfiguration(
                ManagedPersistenceMonitoringConfiguration managedPersistenceMonitoringConfiguration);

        /**
         * <p>
         * The managed log persistence configuration for a job run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ManagedPersistenceMonitoringConfiguration.Builder} avoiding the need to create one manually via
         * {@link ManagedPersistenceMonitoringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedPersistenceMonitoringConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #managedPersistenceMonitoringConfiguration(ManagedPersistenceMonitoringConfiguration)}.
         * 
         * @param managedPersistenceMonitoringConfiguration
         *        a consumer that will call methods on {@link ManagedPersistenceMonitoringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedPersistenceMonitoringConfiguration(ManagedPersistenceMonitoringConfiguration)
         */
        default Builder managedPersistenceMonitoringConfiguration(
                Consumer<ManagedPersistenceMonitoringConfiguration.Builder> managedPersistenceMonitoringConfiguration) {
            return managedPersistenceMonitoringConfiguration(ManagedPersistenceMonitoringConfiguration.builder()
                    .applyMutation(managedPersistenceMonitoringConfiguration).build());
        }

        /**
         * <p>
         * The Amazon CloudWatch configuration for monitoring logs. You can configure your jobs to send log information
         * to CloudWatch.
         * </p>
         * 
         * @param cloudWatchLoggingConfiguration
         *        The Amazon CloudWatch configuration for monitoring logs. You can configure your jobs to send log
         *        information to CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration);

        /**
         * <p>
         * The Amazon CloudWatch configuration for monitoring logs. You can configure your jobs to send log information
         * to CloudWatch.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLoggingConfiguration.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLoggingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration)}.
         * 
         * @param cloudWatchLoggingConfiguration
         *        a consumer that will call methods on {@link CloudWatchLoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration)
         */
        default Builder cloudWatchLoggingConfiguration(
                Consumer<CloudWatchLoggingConfiguration.Builder> cloudWatchLoggingConfiguration) {
            return cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration.builder()
                    .applyMutation(cloudWatchLoggingConfiguration).build());
        }

        /**
         * <p>
         * The monitoring configuration object you can configure to send metrics to Amazon Managed Service for
         * Prometheus for a job run.
         * </p>
         * 
         * @param prometheusMonitoringConfiguration
         *        The monitoring configuration object you can configure to send metrics to Amazon Managed Service for
         *        Prometheus for a job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prometheusMonitoringConfiguration(PrometheusMonitoringConfiguration prometheusMonitoringConfiguration);

        /**
         * <p>
         * The monitoring configuration object you can configure to send metrics to Amazon Managed Service for
         * Prometheus for a job run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PrometheusMonitoringConfiguration.Builder} avoiding the need to create one manually via
         * {@link PrometheusMonitoringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrometheusMonitoringConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #prometheusMonitoringConfiguration(PrometheusMonitoringConfiguration)}.
         * 
         * @param prometheusMonitoringConfiguration
         *        a consumer that will call methods on {@link PrometheusMonitoringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prometheusMonitoringConfiguration(PrometheusMonitoringConfiguration)
         */
        default Builder prometheusMonitoringConfiguration(
                Consumer<PrometheusMonitoringConfiguration.Builder> prometheusMonitoringConfiguration) {
            return prometheusMonitoringConfiguration(PrometheusMonitoringConfiguration.builder()
                    .applyMutation(prometheusMonitoringConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3MonitoringConfiguration s3MonitoringConfiguration;

        private ManagedPersistenceMonitoringConfiguration managedPersistenceMonitoringConfiguration;

        private CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration;

        private PrometheusMonitoringConfiguration prometheusMonitoringConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringConfiguration model) {
            s3MonitoringConfiguration(model.s3MonitoringConfiguration);
            managedPersistenceMonitoringConfiguration(model.managedPersistenceMonitoringConfiguration);
            cloudWatchLoggingConfiguration(model.cloudWatchLoggingConfiguration);
            prometheusMonitoringConfiguration(model.prometheusMonitoringConfiguration);
        }

        public final S3MonitoringConfiguration.Builder getS3MonitoringConfiguration() {
            return s3MonitoringConfiguration != null ? s3MonitoringConfiguration.toBuilder() : null;
        }

        public final void setS3MonitoringConfiguration(S3MonitoringConfiguration.BuilderImpl s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration != null ? s3MonitoringConfiguration.build() : null;
        }

        @Override
        public final Builder s3MonitoringConfiguration(S3MonitoringConfiguration s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration;
            return this;
        }

        public final ManagedPersistenceMonitoringConfiguration.Builder getManagedPersistenceMonitoringConfiguration() {
            return managedPersistenceMonitoringConfiguration != null ? managedPersistenceMonitoringConfiguration.toBuilder()
                    : null;
        }

        public final void setManagedPersistenceMonitoringConfiguration(
                ManagedPersistenceMonitoringConfiguration.BuilderImpl managedPersistenceMonitoringConfiguration) {
            this.managedPersistenceMonitoringConfiguration = managedPersistenceMonitoringConfiguration != null ? managedPersistenceMonitoringConfiguration
                    .build() : null;
        }

        @Override
        public final Builder managedPersistenceMonitoringConfiguration(
                ManagedPersistenceMonitoringConfiguration managedPersistenceMonitoringConfiguration) {
            this.managedPersistenceMonitoringConfiguration = managedPersistenceMonitoringConfiguration;
            return this;
        }

        public final CloudWatchLoggingConfiguration.Builder getCloudWatchLoggingConfiguration() {
            return cloudWatchLoggingConfiguration != null ? cloudWatchLoggingConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchLoggingConfiguration(
                CloudWatchLoggingConfiguration.BuilderImpl cloudWatchLoggingConfiguration) {
            this.cloudWatchLoggingConfiguration = cloudWatchLoggingConfiguration != null ? cloudWatchLoggingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder cloudWatchLoggingConfiguration(CloudWatchLoggingConfiguration cloudWatchLoggingConfiguration) {
            this.cloudWatchLoggingConfiguration = cloudWatchLoggingConfiguration;
            return this;
        }

        public final PrometheusMonitoringConfiguration.Builder getPrometheusMonitoringConfiguration() {
            return prometheusMonitoringConfiguration != null ? prometheusMonitoringConfiguration.toBuilder() : null;
        }

        public final void setPrometheusMonitoringConfiguration(
                PrometheusMonitoringConfiguration.BuilderImpl prometheusMonitoringConfiguration) {
            this.prometheusMonitoringConfiguration = prometheusMonitoringConfiguration != null ? prometheusMonitoringConfiguration
                    .build() : null;
        }

        @Override
        public final Builder prometheusMonitoringConfiguration(PrometheusMonitoringConfiguration prometheusMonitoringConfiguration) {
            this.prometheusMonitoringConfiguration = prometheusMonitoringConfiguration;
            return this;
        }

        @Override
        public MonitoringConfiguration build() {
            return new MonitoringConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
