/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration to use to enable the different types of interactive use cases in an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InteractiveConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InteractiveConfiguration.Builder, InteractiveConfiguration> {
    private static final SdkField<Boolean> STUDIO_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("studioEnabled").getter(getter(InteractiveConfiguration::studioEnabled))
            .setter(setter(Builder::studioEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioEnabled").build()).build();

    private static final SdkField<Boolean> LIVY_ENDPOINT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("livyEndpointEnabled").getter(getter(InteractiveConfiguration::livyEndpointEnabled))
            .setter(setter(Builder::livyEndpointEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("livyEndpointEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIO_ENABLED_FIELD,
            LIVY_ENDPOINT_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean studioEnabled;

    private final Boolean livyEndpointEnabled;

    private InteractiveConfiguration(BuilderImpl builder) {
        this.studioEnabled = builder.studioEnabled;
        this.livyEndpointEnabled = builder.livyEndpointEnabled;
    }

    /**
     * <p>
     * Enables you to connect an application to Amazon EMR Studio to run interactive workloads in a notebook.
     * </p>
     * 
     * @return Enables you to connect an application to Amazon EMR Studio to run interactive workloads in a notebook.
     */
    public final Boolean studioEnabled() {
        return studioEnabled;
    }

    /**
     * <p>
     * Enables an Apache Livy endpoint that you can connect to and run interactive jobs.
     * </p>
     * 
     * @return Enables an Apache Livy endpoint that you can connect to and run interactive jobs.
     */
    public final Boolean livyEndpointEnabled() {
        return livyEndpointEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(studioEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(livyEndpointEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InteractiveConfiguration)) {
            return false;
        }
        InteractiveConfiguration other = (InteractiveConfiguration) obj;
        return Objects.equals(studioEnabled(), other.studioEnabled())
                && Objects.equals(livyEndpointEnabled(), other.livyEndpointEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InteractiveConfiguration").add("StudioEnabled", studioEnabled())
                .add("LivyEndpointEnabled", livyEndpointEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "studioEnabled":
            return Optional.ofNullable(clazz.cast(studioEnabled()));
        case "livyEndpointEnabled":
            return Optional.ofNullable(clazz.cast(livyEndpointEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("studioEnabled", STUDIO_ENABLED_FIELD);
        map.put("livyEndpointEnabled", LIVY_ENDPOINT_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InteractiveConfiguration, T> g) {
        return obj -> g.apply((InteractiveConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InteractiveConfiguration> {
        /**
         * <p>
         * Enables you to connect an application to Amazon EMR Studio to run interactive workloads in a notebook.
         * </p>
         * 
         * @param studioEnabled
         *        Enables you to connect an application to Amazon EMR Studio to run interactive workloads in a notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioEnabled(Boolean studioEnabled);

        /**
         * <p>
         * Enables an Apache Livy endpoint that you can connect to and run interactive jobs.
         * </p>
         * 
         * @param livyEndpointEnabled
         *        Enables an Apache Livy endpoint that you can connect to and run interactive jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder livyEndpointEnabled(Boolean livyEndpointEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean studioEnabled;

        private Boolean livyEndpointEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(InteractiveConfiguration model) {
            studioEnabled(model.studioEnabled);
            livyEndpointEnabled(model.livyEndpointEnabled);
        }

        public final Boolean getStudioEnabled() {
            return studioEnabled;
        }

        public final void setStudioEnabled(Boolean studioEnabled) {
            this.studioEnabled = studioEnabled;
        }

        @Override
        public final Builder studioEnabled(Boolean studioEnabled) {
            this.studioEnabled = studioEnabled;
            return this;
        }

        public final Boolean getLivyEndpointEnabled() {
            return livyEndpointEnabled;
        }

        public final void setLivyEndpointEnabled(Boolean livyEndpointEnabled) {
            this.livyEndpointEnabled = livyEndpointEnabled;
        }

        @Override
        public final Builder livyEndpointEnabled(Boolean livyEndpointEnabled) {
            this.livyEndpointEnabled = livyEndpointEnabled;
            return this;
        }

        @Override
        public InteractiveConfiguration build() {
            return new InteractiveConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
