/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The cumulative configuration requirements for every worker instance of the worker type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkerResourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkerResourceConfig.Builder, WorkerResourceConfig> {
    private static final SdkField<String> CPU_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cpu")
            .getter(getter(WorkerResourceConfig::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()).build();

    private static final SdkField<String> MEMORY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("memory")
            .getter(getter(WorkerResourceConfig::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<String> DISK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("disk")
            .getter(getter(WorkerResourceConfig::disk)).setter(setter(Builder::disk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disk").build()).build();

    private static final SdkField<String> DISK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diskType").getter(getter(WorkerResourceConfig::diskType)).setter(setter(Builder::diskType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_FIELD, MEMORY_FIELD,
            DISK_FIELD, DISK_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cpu;

    private final String memory;

    private final String disk;

    private final String diskType;

    private WorkerResourceConfig(BuilderImpl builder) {
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.disk = builder.disk;
        this.diskType = builder.diskType;
    }

    /**
     * <p>
     * The CPU requirements for every worker instance of the worker type.
     * </p>
     * 
     * @return The CPU requirements for every worker instance of the worker type.
     */
    public final String cpu() {
        return cpu;
    }

    /**
     * <p>
     * The memory requirements for every worker instance of the worker type.
     * </p>
     * 
     * @return The memory requirements for every worker instance of the worker type.
     */
    public final String memory() {
        return memory;
    }

    /**
     * <p>
     * The disk requirements for every worker instance of the worker type.
     * </p>
     * 
     * @return The disk requirements for every worker instance of the worker type.
     */
    public final String disk() {
        return disk;
    }

    /**
     * <p>
     * The disk type for every worker instance of the work type. Shuffle optimized disks have higher performance
     * characteristics and are better for shuffle heavy workloads. Default is <code>STANDARD</code>.
     * </p>
     * 
     * @return The disk type for every worker instance of the work type. Shuffle optimized disks have higher performance
     *         characteristics and are better for shuffle heavy workloads. Default is <code>STANDARD</code>.
     */
    public final String diskType() {
        return diskType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(disk());
        hashCode = 31 * hashCode + Objects.hashCode(diskType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerResourceConfig)) {
            return false;
        }
        WorkerResourceConfig other = (WorkerResourceConfig) obj;
        return Objects.equals(cpu(), other.cpu()) && Objects.equals(memory(), other.memory())
                && Objects.equals(disk(), other.disk()) && Objects.equals(diskType(), other.diskType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkerResourceConfig").add("Cpu", cpu()).add("Memory", memory()).add("Disk", disk())
                .add("DiskType", diskType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "disk":
            return Optional.ofNullable(clazz.cast(disk()));
        case "diskType":
            return Optional.ofNullable(clazz.cast(diskType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkerResourceConfig, T> g) {
        return obj -> g.apply((WorkerResourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkerResourceConfig> {
        /**
         * <p>
         * The CPU requirements for every worker instance of the worker type.
         * </p>
         * 
         * @param cpu
         *        The CPU requirements for every worker instance of the worker type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(String cpu);

        /**
         * <p>
         * The memory requirements for every worker instance of the worker type.
         * </p>
         * 
         * @param memory
         *        The memory requirements for every worker instance of the worker type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(String memory);

        /**
         * <p>
         * The disk requirements for every worker instance of the worker type.
         * </p>
         * 
         * @param disk
         *        The disk requirements for every worker instance of the worker type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disk(String disk);

        /**
         * <p>
         * The disk type for every worker instance of the work type. Shuffle optimized disks have higher performance
         * characteristics and are better for shuffle heavy workloads. Default is <code>STANDARD</code>.
         * </p>
         * 
         * @param diskType
         *        The disk type for every worker instance of the work type. Shuffle optimized disks have higher
         *        performance characteristics and are better for shuffle heavy workloads. Default is
         *        <code>STANDARD</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskType(String diskType);
    }

    static final class BuilderImpl implements Builder {
        private String cpu;

        private String memory;

        private String disk;

        private String diskType;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerResourceConfig model) {
            cpu(model.cpu);
            memory(model.memory);
            disk(model.disk);
            diskType(model.diskType);
        }

        public final String getCpu() {
            return cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final String getMemory() {
            return memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final String getDisk() {
            return disk;
        }

        public final void setDisk(String disk) {
            this.disk = disk;
        }

        @Override
        public final Builder disk(String disk) {
            this.disk = disk;
            return this;
        }

        public final String getDiskType() {
            return diskType;
        }

        public final void setDiskType(String diskType) {
            this.diskType = diskType;
        }

        @Override
        public final Builder diskType(String diskType) {
            this.diskType = diskType;
            return this;
        }

        @Override
        public WorkerResourceConfig build() {
            return new WorkerResourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
