/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emrserverless.EmrServerlessClient;
import software.amazon.awssdk.services.emrserverless.model.JobRunSummary;
import software.amazon.awssdk.services.emrserverless.model.ListJobRunsRequest;
import software.amazon.awssdk.services.emrserverless.model.ListJobRunsResponse;

public class ListJobRunsIterable
implements SdkIterable<ListJobRunsResponse> {
    private final EmrServerlessClient client;
    private final ListJobRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobRunsIterable(EmrServerlessClient client, ListJobRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListJobRunsResponseFetcher();
    }

    public Iterator<ListJobRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobRunSummary> jobRuns() {
        Function<ListJobRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobRuns() != null) {
                return response.jobRuns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobRunsResponseFetcher
    implements SyncPageFetcher<ListJobRunsResponse> {
        private ListJobRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJobRunsResponse nextPage(ListJobRunsResponse previousPage) {
            if (previousPage == null) {
                return ListJobRunsIterable.this.client.listJobRuns(ListJobRunsIterable.this.firstRequest);
            }
            return ListJobRunsIterable.this.client.listJobRuns((ListJobRunsRequest)((Object)ListJobRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

