/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emrcontainers.model.EmrContainersResponse;
import software.amazon.awssdk.services.emrcontainers.model.SecurityConfiguration;
import software.amazon.awssdk.services.emrcontainers.model.SecurityConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecurityConfigurationsResponse
extends EmrContainersResponse
implements ToCopyableBuilder<Builder, ListSecurityConfigurationsResponse> {
    private static final SdkField<List<SecurityConfiguration>> SECURITY_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityConfigurations").getter(ListSecurityConfigurationsResponse.getter(ListSecurityConfigurationsResponse::securityConfigurations)).setter(ListSecurityConfigurationsResponse.setter(Builder::securityConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSecurityConfigurationsResponse.getter(ListSecurityConfigurationsResponse::nextToken)).setter(ListSecurityConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSecurityConfigurationsResponse.memberNameToFieldInitializer();
    private final List<SecurityConfiguration> securityConfigurations;
    private final String nextToken;

    private ListSecurityConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.securityConfigurations = builder.securityConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSecurityConfigurations() {
        return this.securityConfigurations != null && !(this.securityConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SecurityConfiguration> securityConfigurations() {
        return this.securityConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityConfigurations() ? this.securityConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityConfigurationsResponse)) {
            return false;
        }
        ListSecurityConfigurationsResponse other = (ListSecurityConfigurationsResponse)((Object)obj);
        return this.hasSecurityConfigurations() == other.hasSecurityConfigurations() && Objects.equals(this.securityConfigurations(), other.securityConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSecurityConfigurationsResponse").add("SecurityConfigurations", this.hasSecurityConfigurations() ? this.securityConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityConfigurations": {
                return Optional.ofNullable(clazz.cast(this.securityConfigurations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("securityConfigurations", SECURITY_CONFIGURATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityConfigurationsResponse, T> g) {
        return obj -> g.apply((ListSecurityConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrContainersResponse.BuilderImpl
    implements Builder {
        private List<SecurityConfiguration> securityConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityConfigurationsResponse model) {
            super(model);
            this.securityConfigurations(model.securityConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<SecurityConfiguration.Builder> getSecurityConfigurations() {
            List<SecurityConfiguration.Builder> result = SecurityConfigurationsCopier.copyToBuilder(this.securityConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityConfigurations(Collection<SecurityConfiguration.BuilderImpl> securityConfigurations) {
            this.securityConfigurations = SecurityConfigurationsCopier.copyFromBuilder(securityConfigurations);
        }

        @Override
        public final Builder securityConfigurations(Collection<SecurityConfiguration> securityConfigurations) {
            this.securityConfigurations = SecurityConfigurationsCopier.copy(securityConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityConfigurations(SecurityConfiguration ... securityConfigurations) {
            this.securityConfigurations(Arrays.asList(securityConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityConfigurations(Consumer<SecurityConfiguration.Builder> ... securityConfigurations) {
            this.securityConfigurations(Stream.of(securityConfigurations).map(c -> (SecurityConfiguration)((SecurityConfiguration.Builder)SecurityConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSecurityConfigurationsResponse build() {
            return new ListSecurityConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EmrContainersResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSecurityConfigurationsResponse> {
        public Builder securityConfigurations(Collection<SecurityConfiguration> var1);

        public Builder securityConfigurations(SecurityConfiguration ... var1);

        public Builder securityConfigurations(Consumer<SecurityConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

