/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrcontainers.model.CloudWatchMonitoringConfiguration;
import software.amazon.awssdk.services.emrcontainers.model.ContainerLogRotationConfiguration;
import software.amazon.awssdk.services.emrcontainers.model.ManagedLogs;
import software.amazon.awssdk.services.emrcontainers.model.PersistentAppUI;
import software.amazon.awssdk.services.emrcontainers.model.S3MonitoringConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringConfiguration> {
    private static final SdkField<ManagedLogs> MANAGED_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("managedLogs").getter(MonitoringConfiguration.getter(MonitoringConfiguration::managedLogs)).setter(MonitoringConfiguration.setter(Builder::managedLogs)).constructor(ManagedLogs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedLogs").build()}).build();
    private static final SdkField<String> PERSISTENT_APP_UI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("persistentAppUI").getter(MonitoringConfiguration.getter(MonitoringConfiguration::persistentAppUIAsString)).setter(MonitoringConfiguration.setter(Builder::persistentAppUI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("persistentAppUI").build()}).build();
    private static final SdkField<CloudWatchMonitoringConfiguration> CLOUD_WATCH_MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchMonitoringConfiguration").getter(MonitoringConfiguration.getter(MonitoringConfiguration::cloudWatchMonitoringConfiguration)).setter(MonitoringConfiguration.setter(Builder::cloudWatchMonitoringConfiguration)).constructor(CloudWatchMonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchMonitoringConfiguration").build()}).build();
    private static final SdkField<S3MonitoringConfiguration> S3_MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3MonitoringConfiguration").getter(MonitoringConfiguration.getter(MonitoringConfiguration::s3MonitoringConfiguration)).setter(MonitoringConfiguration.setter(Builder::s3MonitoringConfiguration)).constructor(S3MonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3MonitoringConfiguration").build()}).build();
    private static final SdkField<ContainerLogRotationConfiguration> CONTAINER_LOG_ROTATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerLogRotationConfiguration").getter(MonitoringConfiguration.getter(MonitoringConfiguration::containerLogRotationConfiguration)).setter(MonitoringConfiguration.setter(Builder::containerLogRotationConfiguration)).constructor(ContainerLogRotationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerLogRotationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_LOGS_FIELD, PERSISTENT_APP_UI_FIELD, CLOUD_WATCH_MONITORING_CONFIGURATION_FIELD, S3_MONITORING_CONFIGURATION_FIELD, CONTAINER_LOG_ROTATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MonitoringConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ManagedLogs managedLogs;
    private final String persistentAppUI;
    private final CloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration;
    private final S3MonitoringConfiguration s3MonitoringConfiguration;
    private final ContainerLogRotationConfiguration containerLogRotationConfiguration;

    private MonitoringConfiguration(BuilderImpl builder) {
        this.managedLogs = builder.managedLogs;
        this.persistentAppUI = builder.persistentAppUI;
        this.cloudWatchMonitoringConfiguration = builder.cloudWatchMonitoringConfiguration;
        this.s3MonitoringConfiguration = builder.s3MonitoringConfiguration;
        this.containerLogRotationConfiguration = builder.containerLogRotationConfiguration;
    }

    public final ManagedLogs managedLogs() {
        return this.managedLogs;
    }

    public final PersistentAppUI persistentAppUI() {
        return PersistentAppUI.fromValue(this.persistentAppUI);
    }

    public final String persistentAppUIAsString() {
        return this.persistentAppUI;
    }

    public final CloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration() {
        return this.cloudWatchMonitoringConfiguration;
    }

    public final S3MonitoringConfiguration s3MonitoringConfiguration() {
        return this.s3MonitoringConfiguration;
    }

    public final ContainerLogRotationConfiguration containerLogRotationConfiguration() {
        return this.containerLogRotationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.managedLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistentAppUIAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchMonitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3MonitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerLogRotationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringConfiguration)) {
            return false;
        }
        MonitoringConfiguration other = (MonitoringConfiguration)obj;
        return Objects.equals(this.managedLogs(), other.managedLogs()) && Objects.equals(this.persistentAppUIAsString(), other.persistentAppUIAsString()) && Objects.equals(this.cloudWatchMonitoringConfiguration(), other.cloudWatchMonitoringConfiguration()) && Objects.equals(this.s3MonitoringConfiguration(), other.s3MonitoringConfiguration()) && Objects.equals(this.containerLogRotationConfiguration(), other.containerLogRotationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringConfiguration").add("ManagedLogs", (Object)this.managedLogs()).add("PersistentAppUI", (Object)this.persistentAppUIAsString()).add("CloudWatchMonitoringConfiguration", (Object)this.cloudWatchMonitoringConfiguration()).add("S3MonitoringConfiguration", (Object)this.s3MonitoringConfiguration()).add("ContainerLogRotationConfiguration", (Object)this.containerLogRotationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "managedLogs": {
                return Optional.ofNullable(clazz.cast(this.managedLogs()));
            }
            case "persistentAppUI": {
                return Optional.ofNullable(clazz.cast(this.persistentAppUIAsString()));
            }
            case "cloudWatchMonitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchMonitoringConfiguration()));
            }
            case "s3MonitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3MonitoringConfiguration()));
            }
            case "containerLogRotationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.containerLogRotationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("managedLogs", MANAGED_LOGS_FIELD);
        map.put("persistentAppUI", PERSISTENT_APP_UI_FIELD);
        map.put("cloudWatchMonitoringConfiguration", CLOUD_WATCH_MONITORING_CONFIGURATION_FIELD);
        map.put("s3MonitoringConfiguration", S3_MONITORING_CONFIGURATION_FIELD);
        map.put("containerLogRotationConfiguration", CONTAINER_LOG_ROTATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringConfiguration, T> g) {
        return obj -> g.apply((MonitoringConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ManagedLogs managedLogs;
        private String persistentAppUI;
        private CloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration;
        private S3MonitoringConfiguration s3MonitoringConfiguration;
        private ContainerLogRotationConfiguration containerLogRotationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringConfiguration model) {
            this.managedLogs(model.managedLogs);
            this.persistentAppUI(model.persistentAppUI);
            this.cloudWatchMonitoringConfiguration(model.cloudWatchMonitoringConfiguration);
            this.s3MonitoringConfiguration(model.s3MonitoringConfiguration);
            this.containerLogRotationConfiguration(model.containerLogRotationConfiguration);
        }

        public final ManagedLogs.Builder getManagedLogs() {
            return this.managedLogs != null ? this.managedLogs.toBuilder() : null;
        }

        public final void setManagedLogs(ManagedLogs.BuilderImpl managedLogs) {
            this.managedLogs = managedLogs != null ? managedLogs.build() : null;
        }

        @Override
        public final Builder managedLogs(ManagedLogs managedLogs) {
            this.managedLogs = managedLogs;
            return this;
        }

        public final String getPersistentAppUI() {
            return this.persistentAppUI;
        }

        public final void setPersistentAppUI(String persistentAppUI) {
            this.persistentAppUI = persistentAppUI;
        }

        @Override
        public final Builder persistentAppUI(String persistentAppUI) {
            this.persistentAppUI = persistentAppUI;
            return this;
        }

        @Override
        public final Builder persistentAppUI(PersistentAppUI persistentAppUI) {
            this.persistentAppUI(persistentAppUI == null ? null : persistentAppUI.toString());
            return this;
        }

        public final CloudWatchMonitoringConfiguration.Builder getCloudWatchMonitoringConfiguration() {
            return this.cloudWatchMonitoringConfiguration != null ? this.cloudWatchMonitoringConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchMonitoringConfiguration(CloudWatchMonitoringConfiguration.BuilderImpl cloudWatchMonitoringConfiguration) {
            this.cloudWatchMonitoringConfiguration = cloudWatchMonitoringConfiguration != null ? cloudWatchMonitoringConfiguration.build() : null;
        }

        @Override
        public final Builder cloudWatchMonitoringConfiguration(CloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration) {
            this.cloudWatchMonitoringConfiguration = cloudWatchMonitoringConfiguration;
            return this;
        }

        public final S3MonitoringConfiguration.Builder getS3MonitoringConfiguration() {
            return this.s3MonitoringConfiguration != null ? this.s3MonitoringConfiguration.toBuilder() : null;
        }

        public final void setS3MonitoringConfiguration(S3MonitoringConfiguration.BuilderImpl s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration != null ? s3MonitoringConfiguration.build() : null;
        }

        @Override
        public final Builder s3MonitoringConfiguration(S3MonitoringConfiguration s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration;
            return this;
        }

        public final ContainerLogRotationConfiguration.Builder getContainerLogRotationConfiguration() {
            return this.containerLogRotationConfiguration != null ? this.containerLogRotationConfiguration.toBuilder() : null;
        }

        public final void setContainerLogRotationConfiguration(ContainerLogRotationConfiguration.BuilderImpl containerLogRotationConfiguration) {
            this.containerLogRotationConfiguration = containerLogRotationConfiguration != null ? containerLogRotationConfiguration.build() : null;
        }

        @Override
        public final Builder containerLogRotationConfiguration(ContainerLogRotationConfiguration containerLogRotationConfiguration) {
            this.containerLogRotationConfiguration = containerLogRotationConfiguration;
            return this;
        }

        public MonitoringConfiguration build() {
            return new MonitoringConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringConfiguration> {
        public Builder managedLogs(ManagedLogs var1);

        default public Builder managedLogs(Consumer<ManagedLogs.Builder> managedLogs) {
            return this.managedLogs((ManagedLogs)((ManagedLogs.Builder)ManagedLogs.builder().applyMutation(managedLogs)).build());
        }

        public Builder persistentAppUI(String var1);

        public Builder persistentAppUI(PersistentAppUI var1);

        public Builder cloudWatchMonitoringConfiguration(CloudWatchMonitoringConfiguration var1);

        default public Builder cloudWatchMonitoringConfiguration(Consumer<CloudWatchMonitoringConfiguration.Builder> cloudWatchMonitoringConfiguration) {
            return this.cloudWatchMonitoringConfiguration((CloudWatchMonitoringConfiguration)((CloudWatchMonitoringConfiguration.Builder)CloudWatchMonitoringConfiguration.builder().applyMutation(cloudWatchMonitoringConfiguration)).build());
        }

        public Builder s3MonitoringConfiguration(S3MonitoringConfiguration var1);

        default public Builder s3MonitoringConfiguration(Consumer<S3MonitoringConfiguration.Builder> s3MonitoringConfiguration) {
            return this.s3MonitoringConfiguration((S3MonitoringConfiguration)((S3MonitoringConfiguration.Builder)S3MonitoringConfiguration.builder().applyMutation(s3MonitoringConfiguration)).build());
        }

        public Builder containerLogRotationConfiguration(ContainerLogRotationConfiguration var1);

        default public Builder containerLogRotationConfiguration(Consumer<ContainerLogRotationConfiguration.Builder> containerLogRotationConfiguration) {
            return this.containerLogRotationConfiguration((ContainerLogRotationConfiguration)((ContainerLogRotationConfiguration.Builder)ContainerLogRotationConfiguration.builder().applyMutation(containerLogRotationConfiguration)).build());
        }
    }
}

