/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrcontainers.model.JobDriver;
import software.amazon.awssdk.services.emrcontainers.model.ParametricConfigurationOverrides;
import software.amazon.awssdk.services.emrcontainers.model.TagMapCopier;
import software.amazon.awssdk.services.emrcontainers.model.TemplateParameterConfiguration;
import software.amazon.awssdk.services.emrcontainers.model.TemplateParameterConfigurationMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobTemplateData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobTemplateData> {
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(JobTemplateData.getter(JobTemplateData::executionRoleArn)).setter(JobTemplateData.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseLabel").getter(JobTemplateData.getter(JobTemplateData::releaseLabel)).setter(JobTemplateData.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()}).build();
    private static final SdkField<ParametricConfigurationOverrides> CONFIGURATION_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationOverrides").getter(JobTemplateData.getter(JobTemplateData::configurationOverrides)).setter(JobTemplateData.setter(Builder::configurationOverrides)).constructor(ParametricConfigurationOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationOverrides").build()}).build();
    private static final SdkField<JobDriver> JOB_DRIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobDriver").getter(JobTemplateData.getter(JobTemplateData::jobDriver)).setter(JobTemplateData.setter(Builder::jobDriver)).constructor(JobDriver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDriver").build()}).build();
    private static final SdkField<Map<String, TemplateParameterConfiguration>> PARAMETER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameterConfiguration").getter(JobTemplateData.getter(JobTemplateData::parameterConfiguration)).setter(JobTemplateData.setter(Builder::parameterConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateParameterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> JOB_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("jobTags").getter(JobTemplateData.getter(JobTemplateData::jobTags)).setter(JobTemplateData.setter(Builder::jobTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_ARN_FIELD, RELEASE_LABEL_FIELD, CONFIGURATION_OVERRIDES_FIELD, JOB_DRIVER_FIELD, PARAMETER_CONFIGURATION_FIELD, JOB_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobTemplateData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String executionRoleArn;
    private final String releaseLabel;
    private final ParametricConfigurationOverrides configurationOverrides;
    private final JobDriver jobDriver;
    private final Map<String, TemplateParameterConfiguration> parameterConfiguration;
    private final Map<String, String> jobTags;

    private JobTemplateData(BuilderImpl builder) {
        this.executionRoleArn = builder.executionRoleArn;
        this.releaseLabel = builder.releaseLabel;
        this.configurationOverrides = builder.configurationOverrides;
        this.jobDriver = builder.jobDriver;
        this.parameterConfiguration = builder.parameterConfiguration;
        this.jobTags = builder.jobTags;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final ParametricConfigurationOverrides configurationOverrides() {
        return this.configurationOverrides;
    }

    public final JobDriver jobDriver() {
        return this.jobDriver;
    }

    public final boolean hasParameterConfiguration() {
        return this.parameterConfiguration != null && !(this.parameterConfiguration instanceof SdkAutoConstructMap);
    }

    public final Map<String, TemplateParameterConfiguration> parameterConfiguration() {
        return this.parameterConfiguration;
    }

    public final boolean hasJobTags() {
        return this.jobTags != null && !(this.jobTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> jobTags() {
        return this.jobTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDriver());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterConfiguration() ? this.parameterConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobTags() ? this.jobTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobTemplateData)) {
            return false;
        }
        JobTemplateData other = (JobTemplateData)obj;
        return Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.configurationOverrides(), other.configurationOverrides()) && Objects.equals(this.jobDriver(), other.jobDriver()) && this.hasParameterConfiguration() == other.hasParameterConfiguration() && Objects.equals(this.parameterConfiguration(), other.parameterConfiguration()) && this.hasJobTags() == other.hasJobTags() && Objects.equals(this.jobTags(), other.jobTags());
    }

    public final String toString() {
        return ToString.builder((String)"JobTemplateData").add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("ReleaseLabel", (Object)this.releaseLabel()).add("ConfigurationOverrides", (Object)this.configurationOverrides()).add("JobDriver", (Object)this.jobDriver()).add("ParameterConfiguration", this.hasParameterConfiguration() ? this.parameterConfiguration() : null).add("JobTags", this.hasJobTags() ? this.jobTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "releaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "configurationOverrides": {
                return Optional.ofNullable(clazz.cast(this.configurationOverrides()));
            }
            case "jobDriver": {
                return Optional.ofNullable(clazz.cast(this.jobDriver()));
            }
            case "parameterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.parameterConfiguration()));
            }
            case "jobTags": {
                return Optional.ofNullable(clazz.cast(this.jobTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("releaseLabel", RELEASE_LABEL_FIELD);
        map.put("configurationOverrides", CONFIGURATION_OVERRIDES_FIELD);
        map.put("jobDriver", JOB_DRIVER_FIELD);
        map.put("parameterConfiguration", PARAMETER_CONFIGURATION_FIELD);
        map.put("jobTags", JOB_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobTemplateData, T> g) {
        return obj -> g.apply((JobTemplateData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionRoleArn;
        private String releaseLabel;
        private ParametricConfigurationOverrides configurationOverrides;
        private JobDriver jobDriver;
        private Map<String, TemplateParameterConfiguration> parameterConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> jobTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobTemplateData model) {
            this.executionRoleArn(model.executionRoleArn);
            this.releaseLabel(model.releaseLabel);
            this.configurationOverrides(model.configurationOverrides);
            this.jobDriver(model.jobDriver);
            this.parameterConfiguration(model.parameterConfiguration);
            this.jobTags(model.jobTags);
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final ParametricConfigurationOverrides.Builder getConfigurationOverrides() {
            return this.configurationOverrides != null ? this.configurationOverrides.toBuilder() : null;
        }

        public final void setConfigurationOverrides(ParametricConfigurationOverrides.BuilderImpl configurationOverrides) {
            this.configurationOverrides = configurationOverrides != null ? configurationOverrides.build() : null;
        }

        @Override
        public final Builder configurationOverrides(ParametricConfigurationOverrides configurationOverrides) {
            this.configurationOverrides = configurationOverrides;
            return this;
        }

        public final JobDriver.Builder getJobDriver() {
            return this.jobDriver != null ? this.jobDriver.toBuilder() : null;
        }

        public final void setJobDriver(JobDriver.BuilderImpl jobDriver) {
            this.jobDriver = jobDriver != null ? jobDriver.build() : null;
        }

        @Override
        public final Builder jobDriver(JobDriver jobDriver) {
            this.jobDriver = jobDriver;
            return this;
        }

        public final Map<String, TemplateParameterConfiguration.Builder> getParameterConfiguration() {
            Map<String, TemplateParameterConfiguration.Builder> result = TemplateParameterConfigurationMapCopier.copyToBuilder(this.parameterConfiguration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameterConfiguration(Map<String, TemplateParameterConfiguration.BuilderImpl> parameterConfiguration) {
            this.parameterConfiguration = TemplateParameterConfigurationMapCopier.copyFromBuilder(parameterConfiguration);
        }

        @Override
        public final Builder parameterConfiguration(Map<String, TemplateParameterConfiguration> parameterConfiguration) {
            this.parameterConfiguration = TemplateParameterConfigurationMapCopier.copy(parameterConfiguration);
            return this;
        }

        public final Map<String, String> getJobTags() {
            if (this.jobTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.jobTags;
        }

        public final void setJobTags(Map<String, String> jobTags) {
            this.jobTags = TagMapCopier.copy(jobTags);
        }

        @Override
        public final Builder jobTags(Map<String, String> jobTags) {
            this.jobTags = TagMapCopier.copy(jobTags);
            return this;
        }

        public JobTemplateData build() {
            return new JobTemplateData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobTemplateData> {
        public Builder executionRoleArn(String var1);

        public Builder releaseLabel(String var1);

        public Builder configurationOverrides(ParametricConfigurationOverrides var1);

        default public Builder configurationOverrides(Consumer<ParametricConfigurationOverrides.Builder> configurationOverrides) {
            return this.configurationOverrides((ParametricConfigurationOverrides)((ParametricConfigurationOverrides.Builder)ParametricConfigurationOverrides.builder().applyMutation(configurationOverrides)).build());
        }

        public Builder jobDriver(JobDriver var1);

        default public Builder jobDriver(Consumer<JobDriver.Builder> jobDriver) {
            return this.jobDriver((JobDriver)((JobDriver.Builder)JobDriver.builder().applyMutation(jobDriver)).build());
        }

        public Builder parameterConfiguration(Map<String, TemplateParameterConfiguration> var1);

        public Builder jobTags(Map<String, String> var1);
    }
}

