/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrcontainers.model.EmrContainersRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetManagedEndpointSessionCredentialsRequest
extends EmrContainersRequest
implements ToCopyableBuilder<Builder, GetManagedEndpointSessionCredentialsRequest> {
    private static final SdkField<String> ENDPOINT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointIdentifier").getter(GetManagedEndpointSessionCredentialsRequest.getter(GetManagedEndpointSessionCredentialsRequest::endpointIdentifier)).setter(GetManagedEndpointSessionCredentialsRequest.setter(Builder::endpointIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("endpointId").build()}).build();
    private static final SdkField<String> VIRTUAL_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualClusterIdentifier").getter(GetManagedEndpointSessionCredentialsRequest.getter(GetManagedEndpointSessionCredentialsRequest::virtualClusterIdentifier)).setter(GetManagedEndpointSessionCredentialsRequest.setter(Builder::virtualClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualClusterId").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(GetManagedEndpointSessionCredentialsRequest.getter(GetManagedEndpointSessionCredentialsRequest::executionRoleArn)).setter(GetManagedEndpointSessionCredentialsRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> CREDENTIAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialType").getter(GetManagedEndpointSessionCredentialsRequest.getter(GetManagedEndpointSessionCredentialsRequest::credentialType)).setter(GetManagedEndpointSessionCredentialsRequest.setter(Builder::credentialType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialType").build()}).build();
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("durationInSeconds").getter(GetManagedEndpointSessionCredentialsRequest.getter(GetManagedEndpointSessionCredentialsRequest::durationInSeconds)).setter(GetManagedEndpointSessionCredentialsRequest.setter(Builder::durationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInSeconds").build()}).build();
    private static final SdkField<String> LOG_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logContext").getter(GetManagedEndpointSessionCredentialsRequest.getter(GetManagedEndpointSessionCredentialsRequest::logContext)).setter(GetManagedEndpointSessionCredentialsRequest.setter(Builder::logContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logContext").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(GetManagedEndpointSessionCredentialsRequest.getter(GetManagedEndpointSessionCredentialsRequest::clientToken)).setter(GetManagedEndpointSessionCredentialsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_IDENTIFIER_FIELD, VIRTUAL_CLUSTER_IDENTIFIER_FIELD, EXECUTION_ROLE_ARN_FIELD, CREDENTIAL_TYPE_FIELD, DURATION_IN_SECONDS_FIELD, LOG_CONTEXT_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetManagedEndpointSessionCredentialsRequest.memberNameToFieldInitializer();
    private final String endpointIdentifier;
    private final String virtualClusterIdentifier;
    private final String executionRoleArn;
    private final String credentialType;
    private final Integer durationInSeconds;
    private final String logContext;
    private final String clientToken;

    private GetManagedEndpointSessionCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.endpointIdentifier = builder.endpointIdentifier;
        this.virtualClusterIdentifier = builder.virtualClusterIdentifier;
        this.executionRoleArn = builder.executionRoleArn;
        this.credentialType = builder.credentialType;
        this.durationInSeconds = builder.durationInSeconds;
        this.logContext = builder.logContext;
        this.clientToken = builder.clientToken;
    }

    public final String endpointIdentifier() {
        return this.endpointIdentifier;
    }

    public final String virtualClusterIdentifier() {
        return this.virtualClusterIdentifier;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String credentialType() {
        return this.credentialType;
    }

    public final Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    public final String logContext() {
        return this.logContext;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialType());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.logContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedEndpointSessionCredentialsRequest)) {
            return false;
        }
        GetManagedEndpointSessionCredentialsRequest other = (GetManagedEndpointSessionCredentialsRequest)((Object)obj);
        return Objects.equals(this.endpointIdentifier(), other.endpointIdentifier()) && Objects.equals(this.virtualClusterIdentifier(), other.virtualClusterIdentifier()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.credentialType(), other.credentialType()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds()) && Objects.equals(this.logContext(), other.logContext()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetManagedEndpointSessionCredentialsRequest").add("EndpointIdentifier", (Object)this.endpointIdentifier()).add("VirtualClusterIdentifier", (Object)this.virtualClusterIdentifier()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("CredentialType", (Object)this.credentialType()).add("DurationInSeconds", (Object)this.durationInSeconds()).add("LogContext", (Object)this.logContext()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpointIdentifier": {
                return Optional.ofNullable(clazz.cast(this.endpointIdentifier()));
            }
            case "virtualClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.virtualClusterIdentifier()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "credentialType": {
                return Optional.ofNullable(clazz.cast(this.credentialType()));
            }
            case "durationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInSeconds()));
            }
            case "logContext": {
                return Optional.ofNullable(clazz.cast(this.logContext()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("endpointId", ENDPOINT_IDENTIFIER_FIELD);
        map.put("virtualClusterId", VIRTUAL_CLUSTER_IDENTIFIER_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("credentialType", CREDENTIAL_TYPE_FIELD);
        map.put("durationInSeconds", DURATION_IN_SECONDS_FIELD);
        map.put("logContext", LOG_CONTEXT_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedEndpointSessionCredentialsRequest, T> g) {
        return obj -> g.apply((GetManagedEndpointSessionCredentialsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrContainersRequest.BuilderImpl
    implements Builder {
        private String endpointIdentifier;
        private String virtualClusterIdentifier;
        private String executionRoleArn;
        private String credentialType;
        private Integer durationInSeconds;
        private String logContext;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedEndpointSessionCredentialsRequest model) {
            super(model);
            this.endpointIdentifier(model.endpointIdentifier);
            this.virtualClusterIdentifier(model.virtualClusterIdentifier);
            this.executionRoleArn(model.executionRoleArn);
            this.credentialType(model.credentialType);
            this.durationInSeconds(model.durationInSeconds);
            this.logContext(model.logContext);
            this.clientToken(model.clientToken);
        }

        public final String getEndpointIdentifier() {
            return this.endpointIdentifier;
        }

        public final void setEndpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
        }

        @Override
        public final Builder endpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
            return this;
        }

        public final String getVirtualClusterIdentifier() {
            return this.virtualClusterIdentifier;
        }

        public final void setVirtualClusterIdentifier(String virtualClusterIdentifier) {
            this.virtualClusterIdentifier = virtualClusterIdentifier;
        }

        @Override
        public final Builder virtualClusterIdentifier(String virtualClusterIdentifier) {
            this.virtualClusterIdentifier = virtualClusterIdentifier;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getCredentialType() {
            return this.credentialType;
        }

        public final void setCredentialType(String credentialType) {
            this.credentialType = credentialType;
        }

        @Override
        public final Builder credentialType(String credentialType) {
            this.credentialType = credentialType;
            return this;
        }

        public final Integer getDurationInSeconds() {
            return this.durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final String getLogContext() {
            return this.logContext;
        }

        public final void setLogContext(String logContext) {
            this.logContext = logContext;
        }

        @Override
        public final Builder logContext(String logContext) {
            this.logContext = logContext;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetManagedEndpointSessionCredentialsRequest build() {
            return new GetManagedEndpointSessionCredentialsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrContainersRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetManagedEndpointSessionCredentialsRequest> {
        public Builder endpointIdentifier(String var1);

        public Builder virtualClusterIdentifier(String var1);

        public Builder executionRoleArn(String var1);

        public Builder credentialType(String var1);

        public Builder durationInSeconds(Integer var1);

        public Builder logContext(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

