/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrcontainers.model.ContainerProvider;
import software.amazon.awssdk.services.emrcontainers.model.EmrContainersRequest;
import software.amazon.awssdk.services.emrcontainers.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVirtualClusterRequest
extends EmrContainersRequest
implements ToCopyableBuilder<Builder, CreateVirtualClusterRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateVirtualClusterRequest.getter(CreateVirtualClusterRequest::name)).setter(CreateVirtualClusterRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ContainerProvider> CONTAINER_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerProvider").getter(CreateVirtualClusterRequest.getter(CreateVirtualClusterRequest::containerProvider)).setter(CreateVirtualClusterRequest.setter(Builder::containerProvider)).constructor(ContainerProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerProvider").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateVirtualClusterRequest.getter(CreateVirtualClusterRequest::clientToken)).setter(CreateVirtualClusterRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateVirtualClusterRequest.getter(CreateVirtualClusterRequest::tags)).setter(CreateVirtualClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityConfigurationId").getter(CreateVirtualClusterRequest.getter(CreateVirtualClusterRequest::securityConfigurationId)).setter(CreateVirtualClusterRequest.setter(Builder::securityConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityConfigurationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONTAINER_PROVIDER_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, SECURITY_CONFIGURATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateVirtualClusterRequest.memberNameToFieldInitializer();
    private final String name;
    private final ContainerProvider containerProvider;
    private final String clientToken;
    private final Map<String, String> tags;
    private final String securityConfigurationId;

    private CreateVirtualClusterRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.containerProvider = builder.containerProvider;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.securityConfigurationId = builder.securityConfigurationId;
    }

    public final String name() {
        return this.name;
    }

    public final ContainerProvider containerProvider() {
        return this.containerProvider;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String securityConfigurationId() {
        return this.securityConfigurationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfigurationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVirtualClusterRequest)) {
            return false;
        }
        CreateVirtualClusterRequest other = (CreateVirtualClusterRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.containerProvider(), other.containerProvider()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.securityConfigurationId(), other.securityConfigurationId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVirtualClusterRequest").add("Name", (Object)this.name()).add("ContainerProvider", (Object)this.containerProvider()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).add("SecurityConfigurationId", (Object)this.securityConfigurationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "containerProvider": {
                return Optional.ofNullable(clazz.cast(this.containerProvider()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "securityConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.securityConfigurationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("containerProvider", CONTAINER_PROVIDER_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("securityConfigurationId", SECURITY_CONFIGURATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVirtualClusterRequest, T> g) {
        return obj -> g.apply((CreateVirtualClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrContainersRequest.BuilderImpl
    implements Builder {
        private String name;
        private ContainerProvider containerProvider;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String securityConfigurationId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVirtualClusterRequest model) {
            super(model);
            this.name(model.name);
            this.containerProvider(model.containerProvider);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
            this.securityConfigurationId(model.securityConfigurationId);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ContainerProvider.Builder getContainerProvider() {
            return this.containerProvider != null ? this.containerProvider.toBuilder() : null;
        }

        public final void setContainerProvider(ContainerProvider.BuilderImpl containerProvider) {
            this.containerProvider = containerProvider != null ? containerProvider.build() : null;
        }

        @Override
        public final Builder containerProvider(ContainerProvider containerProvider) {
            this.containerProvider = containerProvider;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getSecurityConfigurationId() {
            return this.securityConfigurationId;
        }

        public final void setSecurityConfigurationId(String securityConfigurationId) {
            this.securityConfigurationId = securityConfigurationId;
        }

        @Override
        public final Builder securityConfigurationId(String securityConfigurationId) {
            this.securityConfigurationId = securityConfigurationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVirtualClusterRequest build() {
            return new CreateVirtualClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrContainersRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVirtualClusterRequest> {
        public Builder name(String var1);

        public Builder containerProvider(ContainerProvider var1);

        default public Builder containerProvider(Consumer<ContainerProvider.Builder> containerProvider) {
            return this.containerProvider((ContainerProvider)((ContainerProvider.Builder)ContainerProvider.builder().applyMutation(containerProvider)).build());
        }

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder securityConfigurationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

