/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrcontainers.model.SecureNamespaceInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LakeFormationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LakeFormationConfiguration> {
    private static final SdkField<String> AUTHORIZED_SESSION_TAG_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizedSessionTagValue").getter(LakeFormationConfiguration.getter(LakeFormationConfiguration::authorizedSessionTagValue)).setter(LakeFormationConfiguration.setter(Builder::authorizedSessionTagValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizedSessionTagValue").build()}).build();
    private static final SdkField<SecureNamespaceInfo> SECURE_NAMESPACE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("secureNamespaceInfo").getter(LakeFormationConfiguration.getter(LakeFormationConfiguration::secureNamespaceInfo)).setter(LakeFormationConfiguration.setter(Builder::secureNamespaceInfo)).constructor(SecureNamespaceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secureNamespaceInfo").build()}).build();
    private static final SdkField<String> QUERY_ENGINE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryEngineRoleArn").getter(LakeFormationConfiguration.getter(LakeFormationConfiguration::queryEngineRoleArn)).setter(LakeFormationConfiguration.setter(Builder::queryEngineRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryEngineRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZED_SESSION_TAG_VALUE_FIELD, SECURE_NAMESPACE_INFO_FIELD, QUERY_ENGINE_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authorizedSessionTagValue;
    private final SecureNamespaceInfo secureNamespaceInfo;
    private final String queryEngineRoleArn;

    private LakeFormationConfiguration(BuilderImpl builder) {
        this.authorizedSessionTagValue = builder.authorizedSessionTagValue;
        this.secureNamespaceInfo = builder.secureNamespaceInfo;
        this.queryEngineRoleArn = builder.queryEngineRoleArn;
    }

    public final String authorizedSessionTagValue() {
        return this.authorizedSessionTagValue;
    }

    public final SecureNamespaceInfo secureNamespaceInfo() {
        return this.secureNamespaceInfo;
    }

    public final String queryEngineRoleArn() {
        return this.queryEngineRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizedSessionTagValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.secureNamespaceInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryEngineRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeFormationConfiguration)) {
            return false;
        }
        LakeFormationConfiguration other = (LakeFormationConfiguration)obj;
        return Objects.equals(this.authorizedSessionTagValue(), other.authorizedSessionTagValue()) && Objects.equals(this.secureNamespaceInfo(), other.secureNamespaceInfo()) && Objects.equals(this.queryEngineRoleArn(), other.queryEngineRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"LakeFormationConfiguration").add("AuthorizedSessionTagValue", (Object)this.authorizedSessionTagValue()).add("SecureNamespaceInfo", (Object)this.secureNamespaceInfo()).add("QueryEngineRoleArn", (Object)this.queryEngineRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizedSessionTagValue": {
                return Optional.ofNullable(clazz.cast(this.authorizedSessionTagValue()));
            }
            case "secureNamespaceInfo": {
                return Optional.ofNullable(clazz.cast(this.secureNamespaceInfo()));
            }
            case "queryEngineRoleArn": {
                return Optional.ofNullable(clazz.cast(this.queryEngineRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LakeFormationConfiguration, T> g) {
        return obj -> g.apply((LakeFormationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authorizedSessionTagValue;
        private SecureNamespaceInfo secureNamespaceInfo;
        private String queryEngineRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LakeFormationConfiguration model) {
            this.authorizedSessionTagValue(model.authorizedSessionTagValue);
            this.secureNamespaceInfo(model.secureNamespaceInfo);
            this.queryEngineRoleArn(model.queryEngineRoleArn);
        }

        public final String getAuthorizedSessionTagValue() {
            return this.authorizedSessionTagValue;
        }

        public final void setAuthorizedSessionTagValue(String authorizedSessionTagValue) {
            this.authorizedSessionTagValue = authorizedSessionTagValue;
        }

        @Override
        public final Builder authorizedSessionTagValue(String authorizedSessionTagValue) {
            this.authorizedSessionTagValue = authorizedSessionTagValue;
            return this;
        }

        public final SecureNamespaceInfo.Builder getSecureNamespaceInfo() {
            return this.secureNamespaceInfo != null ? this.secureNamespaceInfo.toBuilder() : null;
        }

        public final void setSecureNamespaceInfo(SecureNamespaceInfo.BuilderImpl secureNamespaceInfo) {
            this.secureNamespaceInfo = secureNamespaceInfo != null ? secureNamespaceInfo.build() : null;
        }

        @Override
        public final Builder secureNamespaceInfo(SecureNamespaceInfo secureNamespaceInfo) {
            this.secureNamespaceInfo = secureNamespaceInfo;
            return this;
        }

        public final String getQueryEngineRoleArn() {
            return this.queryEngineRoleArn;
        }

        public final void setQueryEngineRoleArn(String queryEngineRoleArn) {
            this.queryEngineRoleArn = queryEngineRoleArn;
        }

        @Override
        public final Builder queryEngineRoleArn(String queryEngineRoleArn) {
            this.queryEngineRoleArn = queryEngineRoleArn;
            return this;
        }

        public LakeFormationConfiguration build() {
            return new LakeFormationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LakeFormationConfiguration> {
        public Builder authorizedSessionTagValue(String var1);

        public Builder secureNamespaceInfo(SecureNamespaceInfo var1);

        default public Builder secureNamespaceInfo(Consumer<SecureNamespaceInfo.Builder> secureNamespaceInfo) {
            return this.secureNamespaceInfo((SecureNamespaceInfo)((SecureNamespaceInfo.Builder)SecureNamespaceInfo.builder().applyMutation(secureNamespaceInfo)).build());
        }

        public Builder queryEngineRoleArn(String var1);
    }
}

