/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The values of StartJobRun API requests used in job runs started using the job template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobTemplateData implements SdkPojo, Serializable, ToCopyableBuilder<JobTemplateData.Builder, JobTemplateData> {
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(JobTemplateData::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("releaseLabel").getter(getter(JobTemplateData::releaseLabel)).setter(setter(Builder::releaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()).build();

    private static final SdkField<ParametricConfigurationOverrides> CONFIGURATION_OVERRIDES_FIELD = SdkField
            .<ParametricConfigurationOverrides> builder(MarshallingType.SDK_POJO).memberName("configurationOverrides")
            .getter(getter(JobTemplateData::configurationOverrides)).setter(setter(Builder::configurationOverrides))
            .constructor(ParametricConfigurationOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationOverrides").build())
            .build();

    private static final SdkField<JobDriver> JOB_DRIVER_FIELD = SdkField.<JobDriver> builder(MarshallingType.SDK_POJO)
            .memberName("jobDriver").getter(getter(JobTemplateData::jobDriver)).setter(setter(Builder::jobDriver))
            .constructor(JobDriver::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDriver").build()).build();

    private static final SdkField<Map<String, TemplateParameterConfiguration>> PARAMETER_CONFIGURATION_FIELD = SdkField
            .<Map<String, TemplateParameterConfiguration>> builder(MarshallingType.MAP)
            .memberName("parameterConfiguration")
            .getter(getter(JobTemplateData::parameterConfiguration))
            .setter(setter(Builder::parameterConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TemplateParameterConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(TemplateParameterConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> JOB_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("jobTags")
            .getter(getter(JobTemplateData::jobTags))
            .setter(setter(Builder::jobTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_ARN_FIELD,
            RELEASE_LABEL_FIELD, CONFIGURATION_OVERRIDES_FIELD, JOB_DRIVER_FIELD, PARAMETER_CONFIGURATION_FIELD, JOB_TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String executionRoleArn;

    private final String releaseLabel;

    private final ParametricConfigurationOverrides configurationOverrides;

    private final JobDriver jobDriver;

    private final Map<String, TemplateParameterConfiguration> parameterConfiguration;

    private final Map<String, String> jobTags;

    private JobTemplateData(BuilderImpl builder) {
        this.executionRoleArn = builder.executionRoleArn;
        this.releaseLabel = builder.releaseLabel;
        this.configurationOverrides = builder.configurationOverrides;
        this.jobDriver = builder.jobDriver;
        this.parameterConfiguration = builder.parameterConfiguration;
        this.jobTags = builder.jobTags;
    }

    /**
     * <p>
     * The execution role ARN of the job run.
     * </p>
     * 
     * @return The execution role ARN of the job run.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The release version of Amazon EMR.
     * </p>
     * 
     * @return The release version of Amazon EMR.
     */
    public final String releaseLabel() {
        return releaseLabel;
    }

    /**
     * <p>
     * The configuration settings that are used to override defaults configuration.
     * </p>
     * 
     * @return The configuration settings that are used to override defaults configuration.
     */
    public final ParametricConfigurationOverrides configurationOverrides() {
        return configurationOverrides;
    }

    /**
     * Returns the value of the JobDriver property for this object.
     * 
     * @return The value of the JobDriver property for this object.
     */
    public final JobDriver jobDriver() {
        return jobDriver;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasParameterConfiguration() {
        return parameterConfiguration != null && !(parameterConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration of parameters existing in the job template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterConfiguration} method.
     * </p>
     * 
     * @return The configuration of parameters existing in the job template.
     */
    public final Map<String, TemplateParameterConfiguration> parameterConfiguration() {
        return parameterConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobTags() {
        return jobTags != null && !(jobTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to jobs started using the job template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobTags} method.
     * </p>
     * 
     * @return The tags assigned to jobs started using the job template.
     */
    public final Map<String, String> jobTags() {
        return jobTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(configurationOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(jobDriver());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterConfiguration() ? parameterConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasJobTags() ? jobTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobTemplateData)) {
            return false;
        }
        JobTemplateData other = (JobTemplateData) obj;
        return Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(releaseLabel(), other.releaseLabel())
                && Objects.equals(configurationOverrides(), other.configurationOverrides())
                && Objects.equals(jobDriver(), other.jobDriver())
                && hasParameterConfiguration() == other.hasParameterConfiguration()
                && Objects.equals(parameterConfiguration(), other.parameterConfiguration()) && hasJobTags() == other.hasJobTags()
                && Objects.equals(jobTags(), other.jobTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobTemplateData").add("ExecutionRoleArn", executionRoleArn())
                .add("ReleaseLabel", releaseLabel()).add("ConfigurationOverrides", configurationOverrides())
                .add("JobDriver", jobDriver())
                .add("ParameterConfiguration", hasParameterConfiguration() ? parameterConfiguration() : null)
                .add("JobTags", hasJobTags() ? jobTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "releaseLabel":
            return Optional.ofNullable(clazz.cast(releaseLabel()));
        case "configurationOverrides":
            return Optional.ofNullable(clazz.cast(configurationOverrides()));
        case "jobDriver":
            return Optional.ofNullable(clazz.cast(jobDriver()));
        case "parameterConfiguration":
            return Optional.ofNullable(clazz.cast(parameterConfiguration()));
        case "jobTags":
            return Optional.ofNullable(clazz.cast(jobTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobTemplateData, T> g) {
        return obj -> g.apply((JobTemplateData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobTemplateData> {
        /**
         * <p>
         * The execution role ARN of the job run.
         * </p>
         * 
         * @param executionRoleArn
         *        The execution role ARN of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The release version of Amazon EMR.
         * </p>
         * 
         * @param releaseLabel
         *        The release version of Amazon EMR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseLabel(String releaseLabel);

        /**
         * <p>
         * The configuration settings that are used to override defaults configuration.
         * </p>
         * 
         * @param configurationOverrides
         *        The configuration settings that are used to override defaults configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationOverrides(ParametricConfigurationOverrides configurationOverrides);

        /**
         * <p>
         * The configuration settings that are used to override defaults configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParametricConfigurationOverrides.Builder}
         * avoiding the need to create one manually via {@link ParametricConfigurationOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParametricConfigurationOverrides.Builder#build()} is called
         * immediately and its result is passed to {@link #configurationOverrides(ParametricConfigurationOverrides)}.
         * 
         * @param configurationOverrides
         *        a consumer that will call methods on {@link ParametricConfigurationOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationOverrides(ParametricConfigurationOverrides)
         */
        default Builder configurationOverrides(Consumer<ParametricConfigurationOverrides.Builder> configurationOverrides) {
            return configurationOverrides(ParametricConfigurationOverrides.builder().applyMutation(configurationOverrides)
                    .build());
        }

        /**
         * Sets the value of the JobDriver property for this object.
         *
         * @param jobDriver
         *        The new value for the JobDriver property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDriver(JobDriver jobDriver);

        /**
         * Sets the value of the JobDriver property for this object.
         *
         * This is a convenience method that creates an instance of the {@link JobDriver.Builder} avoiding the need to
         * create one manually via {@link JobDriver#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobDriver.Builder#build()} is called immediately and its result
         * is passed to {@link #jobDriver(JobDriver)}.
         * 
         * @param jobDriver
         *        a consumer that will call methods on {@link JobDriver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobDriver(JobDriver)
         */
        default Builder jobDriver(Consumer<JobDriver.Builder> jobDriver) {
            return jobDriver(JobDriver.builder().applyMutation(jobDriver).build());
        }

        /**
         * <p>
         * The configuration of parameters existing in the job template.
         * </p>
         * 
         * @param parameterConfiguration
         *        The configuration of parameters existing in the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterConfiguration(Map<String, TemplateParameterConfiguration> parameterConfiguration);

        /**
         * <p>
         * The tags assigned to jobs started using the job template.
         * </p>
         * 
         * @param jobTags
         *        The tags assigned to jobs started using the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(Map<String, String> jobTags);
    }

    static final class BuilderImpl implements Builder {
        private String executionRoleArn;

        private String releaseLabel;

        private ParametricConfigurationOverrides configurationOverrides;

        private JobDriver jobDriver;

        private Map<String, TemplateParameterConfiguration> parameterConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> jobTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobTemplateData model) {
            executionRoleArn(model.executionRoleArn);
            releaseLabel(model.releaseLabel);
            configurationOverrides(model.configurationOverrides);
            jobDriver(model.jobDriver);
            parameterConfiguration(model.parameterConfiguration);
            jobTags(model.jobTags);
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getReleaseLabel() {
            return releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final ParametricConfigurationOverrides.Builder getConfigurationOverrides() {
            return configurationOverrides != null ? configurationOverrides.toBuilder() : null;
        }

        public final void setConfigurationOverrides(ParametricConfigurationOverrides.BuilderImpl configurationOverrides) {
            this.configurationOverrides = configurationOverrides != null ? configurationOverrides.build() : null;
        }

        @Override
        public final Builder configurationOverrides(ParametricConfigurationOverrides configurationOverrides) {
            this.configurationOverrides = configurationOverrides;
            return this;
        }

        public final JobDriver.Builder getJobDriver() {
            return jobDriver != null ? jobDriver.toBuilder() : null;
        }

        public final void setJobDriver(JobDriver.BuilderImpl jobDriver) {
            this.jobDriver = jobDriver != null ? jobDriver.build() : null;
        }

        @Override
        public final Builder jobDriver(JobDriver jobDriver) {
            this.jobDriver = jobDriver;
            return this;
        }

        public final Map<String, TemplateParameterConfiguration.Builder> getParameterConfiguration() {
            Map<String, TemplateParameterConfiguration.Builder> result = TemplateParameterConfigurationMapCopier
                    .copyToBuilder(this.parameterConfiguration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameterConfiguration(Map<String, TemplateParameterConfiguration.BuilderImpl> parameterConfiguration) {
            this.parameterConfiguration = TemplateParameterConfigurationMapCopier.copyFromBuilder(parameterConfiguration);
        }

        @Override
        public final Builder parameterConfiguration(Map<String, TemplateParameterConfiguration> parameterConfiguration) {
            this.parameterConfiguration = TemplateParameterConfigurationMapCopier.copy(parameterConfiguration);
            return this;
        }

        public final Map<String, String> getJobTags() {
            if (jobTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return jobTags;
        }

        public final void setJobTags(Map<String, String> jobTags) {
            this.jobTags = TagMapCopier.copy(jobTags);
        }

        @Override
        public final Builder jobTags(Map<String, String> jobTags) {
            this.jobTags = TagMapCopier.copy(jobTags);
            return this;
        }

        @Override
        public JobTemplateData build() {
            return new JobTemplateData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
