/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrcontainers.model.ConfigurationOverrides;
import software.amazon.awssdk.services.emrcontainers.model.EmrContainersRequest;
import software.amazon.awssdk.services.emrcontainers.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateManagedEndpointRequest
extends EmrContainersRequest
implements ToCopyableBuilder<Builder, CreateManagedEndpointRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateManagedEndpointRequest.getter(CreateManagedEndpointRequest::name)).setter(CreateManagedEndpointRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VIRTUAL_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualClusterId").getter(CreateManagedEndpointRequest.getter(CreateManagedEndpointRequest::virtualClusterId)).setter(CreateManagedEndpointRequest.setter(Builder::virtualClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualClusterId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateManagedEndpointRequest.getter(CreateManagedEndpointRequest::type)).setter(CreateManagedEndpointRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseLabel").getter(CreateManagedEndpointRequest.getter(CreateManagedEndpointRequest::releaseLabel)).setter(CreateManagedEndpointRequest.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(CreateManagedEndpointRequest.getter(CreateManagedEndpointRequest::executionRoleArn)).setter(CreateManagedEndpointRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateArn").getter(CreateManagedEndpointRequest.getter(CreateManagedEndpointRequest::certificateArn)).setter(CreateManagedEndpointRequest.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<ConfigurationOverrides> CONFIGURATION_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationOverrides").getter(CreateManagedEndpointRequest.getter(CreateManagedEndpointRequest::configurationOverrides)).setter(CreateManagedEndpointRequest.setter(Builder::configurationOverrides)).constructor(ConfigurationOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationOverrides").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateManagedEndpointRequest.getter(CreateManagedEndpointRequest::clientToken)).setter(CreateManagedEndpointRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateManagedEndpointRequest.getter(CreateManagedEndpointRequest::tags)).setter(CreateManagedEndpointRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VIRTUAL_CLUSTER_ID_FIELD, TYPE_FIELD, RELEASE_LABEL_FIELD, EXECUTION_ROLE_ARN_FIELD, CERTIFICATE_ARN_FIELD, CONFIGURATION_OVERRIDES_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private final String name;
    private final String virtualClusterId;
    private final String type;
    private final String releaseLabel;
    private final String executionRoleArn;
    private final String certificateArn;
    private final ConfigurationOverrides configurationOverrides;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateManagedEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.virtualClusterId = builder.virtualClusterId;
        this.type = builder.type;
        this.releaseLabel = builder.releaseLabel;
        this.executionRoleArn = builder.executionRoleArn;
        this.certificateArn = builder.certificateArn;
        this.configurationOverrides = builder.configurationOverrides;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String virtualClusterId() {
        return this.virtualClusterId;
    }

    public final String type() {
        return this.type;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    @Deprecated
    public final String certificateArn() {
        return this.certificateArn;
    }

    public final ConfigurationOverrides configurationOverrides() {
        return this.configurationOverrides;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateManagedEndpointRequest)) {
            return false;
        }
        CreateManagedEndpointRequest other = (CreateManagedEndpointRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.virtualClusterId(), other.virtualClusterId()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.configurationOverrides(), other.configurationOverrides()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateManagedEndpointRequest").add("Name", (Object)this.name()).add("VirtualClusterId", (Object)this.virtualClusterId()).add("Type", (Object)this.type()).add("ReleaseLabel", (Object)this.releaseLabel()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("CertificateArn", (Object)this.certificateArn()).add("ConfigurationOverrides", (Object)this.configurationOverrides()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "virtualClusterId": {
                return Optional.ofNullable(clazz.cast(this.virtualClusterId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "releaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "configurationOverrides": {
                return Optional.ofNullable(clazz.cast(this.configurationOverrides()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateManagedEndpointRequest, T> g) {
        return obj -> g.apply((CreateManagedEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrContainersRequest.BuilderImpl
    implements Builder {
        private String name;
        private String virtualClusterId;
        private String type;
        private String releaseLabel;
        private String executionRoleArn;
        private String certificateArn;
        private ConfigurationOverrides configurationOverrides;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateManagedEndpointRequest model) {
            super(model);
            this.name(model.name);
            this.virtualClusterId(model.virtualClusterId);
            this.type(model.type);
            this.releaseLabel(model.releaseLabel);
            this.executionRoleArn(model.executionRoleArn);
            this.certificateArn(model.certificateArn);
            this.configurationOverrides(model.configurationOverrides);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVirtualClusterId() {
            return this.virtualClusterId;
        }

        public final void setVirtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
        }

        @Override
        public final Builder virtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        @Deprecated
        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Deprecated
        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        @Deprecated
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final ConfigurationOverrides.Builder getConfigurationOverrides() {
            return this.configurationOverrides != null ? this.configurationOverrides.toBuilder() : null;
        }

        public final void setConfigurationOverrides(ConfigurationOverrides.BuilderImpl configurationOverrides) {
            this.configurationOverrides = configurationOverrides != null ? configurationOverrides.build() : null;
        }

        @Override
        public final Builder configurationOverrides(ConfigurationOverrides configurationOverrides) {
            this.configurationOverrides = configurationOverrides;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateManagedEndpointRequest build() {
            return new CreateManagedEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrContainersRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateManagedEndpointRequest> {
        public Builder name(String var1);

        public Builder virtualClusterId(String var1);

        public Builder type(String var1);

        public Builder releaseLabel(String var1);

        public Builder executionRoleArn(String var1);

        @Deprecated
        public Builder certificateArn(String var1);

        public Builder configurationOverrides(ConfigurationOverrides var1);

        default public Builder configurationOverrides(Consumer<ConfigurationOverrides.Builder> configurationOverrides) {
            return this.configurationOverrides((ConfigurationOverrides)((ConfigurationOverrides.Builder)ConfigurationOverrides.builder().applyMutation(configurationOverrides)).build());
        }

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

