/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FailureReason {
    INTERNAL_ERROR("INTERNAL_ERROR"),
    USER_ERROR("USER_ERROR"),
    VALIDATION_ERROR("VALIDATION_ERROR"),
    CLUSTER_UNAVAILABLE("CLUSTER_UNAVAILABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FailureReason> VALUE_MAP;
    private final String value;

    private FailureReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailureReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailureReason> knownValues() {
        EnumSet<FailureReason> knownValues = EnumSet.allOf(FailureReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FailureReason.class, FailureReason::toString);
    }
}

