/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrcontainers.model.EmrContainersRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteManagedEndpointRequest
extends EmrContainersRequest
implements ToCopyableBuilder<Builder, DeleteManagedEndpointRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DeleteManagedEndpointRequest.getter(DeleteManagedEndpointRequest::id)).setter(DeleteManagedEndpointRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("endpointId").build()}).build();
    private static final SdkField<String> VIRTUAL_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualClusterId").getter(DeleteManagedEndpointRequest.getter(DeleteManagedEndpointRequest::virtualClusterId)).setter(DeleteManagedEndpointRequest.setter(Builder::virtualClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualClusterId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VIRTUAL_CLUSTER_ID_FIELD));
    private final String id;
    private final String virtualClusterId;

    private DeleteManagedEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.virtualClusterId = builder.virtualClusterId;
    }

    public final String id() {
        return this.id;
    }

    public final String virtualClusterId() {
        return this.virtualClusterId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualClusterId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteManagedEndpointRequest)) {
            return false;
        }
        DeleteManagedEndpointRequest other = (DeleteManagedEndpointRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.virtualClusterId(), other.virtualClusterId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteManagedEndpointRequest").add("Id", (Object)this.id()).add("VirtualClusterId", (Object)this.virtualClusterId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "virtualClusterId": {
                return Optional.ofNullable(clazz.cast(this.virtualClusterId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteManagedEndpointRequest, T> g) {
        return obj -> g.apply((DeleteManagedEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrContainersRequest.BuilderImpl
    implements Builder {
        private String id;
        private String virtualClusterId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteManagedEndpointRequest model) {
            super(model);
            this.id(model.id);
            this.virtualClusterId(model.virtualClusterId);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getVirtualClusterId() {
            return this.virtualClusterId;
        }

        @Override
        public final Builder virtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
            return this;
        }

        public final void setVirtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteManagedEndpointRequest build() {
            return new DeleteManagedEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrContainersRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteManagedEndpointRequest> {
        public Builder id(String var1);

        public Builder virtualClusterId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

