/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StepState {
    PENDING("PENDING"),
    CANCEL_PENDING("CANCEL_PENDING"),
    RUNNING("RUNNING"),
    COMPLETED("COMPLETED"),
    CANCELLED("CANCELLED"),
    FAILED("FAILED"),
    INTERRUPTED("INTERRUPTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StepState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StepState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StepState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StepState> knownValues() {
        return Stream.of(StepState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

