/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.ActionOnFailure;
import software.amazon.awssdk.services.emr.model.HadoopStepConfig;
import software.amazon.awssdk.services.emr.model.StepStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StepSummary.getter(StepSummary::id)).setter(StepSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StepSummary.getter(StepSummary::name)).setter(StepSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<HadoopStepConfig> CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StepSummary.getter(StepSummary::config)).setter(StepSummary.setter(Builder::config)).constructor(HadoopStepConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build()}).build();
    private static final SdkField<String> ACTION_ON_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StepSummary.getter(StepSummary::actionOnFailureAsString)).setter(StepSummary.setter(Builder::actionOnFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionOnFailure").build()}).build();
    private static final SdkField<StepStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StepSummary.getter(StepSummary::status)).setter(StepSummary.setter(Builder::status)).constructor(StepStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, CONFIG_FIELD, ACTION_ON_FAILURE_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final HadoopStepConfig config;
    private final String actionOnFailure;
    private final StepStatus status;

    private StepSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.config = builder.config;
        this.actionOnFailure = builder.actionOnFailure;
        this.status = builder.status;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public HadoopStepConfig config() {
        return this.config;
    }

    public ActionOnFailure actionOnFailure() {
        return ActionOnFailure.fromValue(this.actionOnFailure);
    }

    public String actionOnFailureAsString() {
        return this.actionOnFailure;
    }

    public StepStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.config());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionOnFailureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepSummary)) {
            return false;
        }
        StepSummary other = (StepSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.config(), other.config()) && Objects.equals(this.actionOnFailureAsString(), other.actionOnFailureAsString()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"StepSummary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Config", (Object)this.config()).add("ActionOnFailure", (Object)this.actionOnFailureAsString()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Config": {
                return Optional.ofNullable(clazz.cast(this.config()));
            }
            case "ActionOnFailure": {
                return Optional.ofNullable(clazz.cast(this.actionOnFailureAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StepSummary, T> g) {
        return obj -> g.apply((StepSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private HadoopStepConfig config;
        private String actionOnFailure;
        private StepStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(StepSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.config(model.config);
            this.actionOnFailure(model.actionOnFailure);
            this.status(model.status);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final HadoopStepConfig.Builder getConfig() {
            return this.config != null ? this.config.toBuilder() : null;
        }

        @Override
        public final Builder config(HadoopStepConfig config) {
            this.config = config;
            return this;
        }

        public final void setConfig(HadoopStepConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        public final String getActionOnFailureAsString() {
            return this.actionOnFailure;
        }

        @Override
        public final Builder actionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
            return this;
        }

        @Override
        public final Builder actionOnFailure(ActionOnFailure actionOnFailure) {
            this.actionOnFailure(actionOnFailure.toString());
            return this;
        }

        public final void setActionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
        }

        public final StepStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(StepStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(StepStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public StepSummary build() {
            return new StepSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder config(HadoopStepConfig var1);

        default public Builder config(Consumer<HadoopStepConfig.Builder> config) {
            return this.config((HadoopStepConfig)((HadoopStepConfig.Builder)HadoopStepConfig.builder().applyMutation(config)).build());
        }

        public Builder actionOnFailure(String var1);

        public Builder actionOnFailure(ActionOnFailure var1);

        public Builder status(StepStatus var1);

        default public Builder status(Consumer<StepStatus.Builder> status) {
            return this.status((StepStatus)((StepStatus.Builder)StepStatus.builder().applyMutation(status)).build());
        }
    }
}

