/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.AdjustmentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimpleScalingPolicyConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SimpleScalingPolicyConfiguration> {
    private static final SdkField<String> ADJUSTMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimpleScalingPolicyConfiguration.getter(SimpleScalingPolicyConfiguration::adjustmentTypeAsString)).setter(SimpleScalingPolicyConfiguration.setter(Builder::adjustmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdjustmentType").build()}).build();
    private static final SdkField<Integer> SCALING_ADJUSTMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SimpleScalingPolicyConfiguration.getter(SimpleScalingPolicyConfiguration::scalingAdjustment)).setter(SimpleScalingPolicyConfiguration.setter(Builder::scalingAdjustment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustment").build()}).build();
    private static final SdkField<Integer> COOL_DOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SimpleScalingPolicyConfiguration.getter(SimpleScalingPolicyConfiguration::coolDown)).setter(SimpleScalingPolicyConfiguration.setter(Builder::coolDown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoolDown").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADJUSTMENT_TYPE_FIELD, SCALING_ADJUSTMENT_FIELD, COOL_DOWN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adjustmentType;
    private final Integer scalingAdjustment;
    private final Integer coolDown;

    private SimpleScalingPolicyConfiguration(BuilderImpl builder) {
        this.adjustmentType = builder.adjustmentType;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.coolDown = builder.coolDown;
    }

    public AdjustmentType adjustmentType() {
        return AdjustmentType.fromValue(this.adjustmentType);
    }

    public String adjustmentTypeAsString() {
        return this.adjustmentType;
    }

    public Integer scalingAdjustment() {
        return this.scalingAdjustment;
    }

    public Integer coolDown() {
        return this.coolDown;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adjustmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingAdjustment());
        hashCode = 31 * hashCode + Objects.hashCode(this.coolDown());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleScalingPolicyConfiguration)) {
            return false;
        }
        SimpleScalingPolicyConfiguration other = (SimpleScalingPolicyConfiguration)obj;
        return Objects.equals(this.adjustmentTypeAsString(), other.adjustmentTypeAsString()) && Objects.equals(this.scalingAdjustment(), other.scalingAdjustment()) && Objects.equals(this.coolDown(), other.coolDown());
    }

    public String toString() {
        return ToString.builder((String)"SimpleScalingPolicyConfiguration").add("AdjustmentType", (Object)this.adjustmentTypeAsString()).add("ScalingAdjustment", (Object)this.scalingAdjustment()).add("CoolDown", (Object)this.coolDown()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdjustmentType": {
                return Optional.ofNullable(clazz.cast(this.adjustmentTypeAsString()));
            }
            case "ScalingAdjustment": {
                return Optional.ofNullable(clazz.cast(this.scalingAdjustment()));
            }
            case "CoolDown": {
                return Optional.ofNullable(clazz.cast(this.coolDown()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimpleScalingPolicyConfiguration, T> g) {
        return obj -> g.apply((SimpleScalingPolicyConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adjustmentType;
        private Integer scalingAdjustment;
        private Integer coolDown;

        private BuilderImpl() {
        }

        private BuilderImpl(SimpleScalingPolicyConfiguration model) {
            this.adjustmentType(model.adjustmentType);
            this.scalingAdjustment(model.scalingAdjustment);
            this.coolDown(model.coolDown);
        }

        public final String getAdjustmentTypeAsString() {
            return this.adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        @Override
        public final Builder adjustmentType(AdjustmentType adjustmentType) {
            this.adjustmentType(adjustmentType.toString());
            return this;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        public final Integer getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public final Integer getCoolDown() {
            return this.coolDown;
        }

        @Override
        public final Builder coolDown(Integer coolDown) {
            this.coolDown = coolDown;
            return this;
        }

        public final void setCoolDown(Integer coolDown) {
            this.coolDown = coolDown;
        }

        public SimpleScalingPolicyConfiguration build() {
            return new SimpleScalingPolicyConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SimpleScalingPolicyConfiguration> {
        public Builder adjustmentType(String var1);

        public Builder adjustmentType(AdjustmentType var1);

        public Builder scalingAdjustment(Integer var1);

        public Builder coolDown(Integer var1);
    }
}

