/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelStepsInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CancelStepsInfo> {
    private static final SdkField<String> STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CancelStepsInfo.getter(CancelStepsInfo::stepId)).setter(CancelStepsInfo.setter(Builder::stepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CancelStepsInfo.getter(CancelStepsInfo::statusAsString)).setter(CancelStepsInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CancelStepsInfo.getter(CancelStepsInfo::reason)).setter(CancelStepsInfo.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_ID_FIELD, STATUS_FIELD, REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stepId;
    private final String status;
    private final String reason;

    private CancelStepsInfo(BuilderImpl builder) {
        this.stepId = builder.stepId;
        this.status = builder.status;
        this.reason = builder.reason;
    }

    public String stepId() {
        return this.stepId;
    }

    public CancelStepsRequestStatus status() {
        return CancelStepsRequestStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelStepsInfo)) {
            return false;
        }
        CancelStepsInfo other = (CancelStepsInfo)obj;
        return Objects.equals(this.stepId(), other.stepId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.reason(), other.reason());
    }

    public String toString() {
        return ToString.builder((String)"CancelStepsInfo").add("StepId", (Object)this.stepId()).add("Status", (Object)this.statusAsString()).add("Reason", (Object)this.reason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepId": {
                return Optional.ofNullable(clazz.cast(this.stepId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelStepsInfo, T> g) {
        return obj -> g.apply((CancelStepsInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stepId;
        private String status;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelStepsInfo model) {
            this.stepId(model.stepId);
            this.status(model.status);
            this.reason(model.reason);
        }

        public final String getStepId() {
            return this.stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CancelStepsRequestStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public CancelStepsInfo build() {
            return new CancelStepsInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CancelStepsInfo> {
        public Builder stepId(String var1);

        public Builder status(String var1);

        public Builder status(CancelStepsRequestStatus var1);

        public Builder reason(String var1);
    }
}

