/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.InstanceFleetProvisioningSpecifications;
import software.amazon.awssdk.services.emr.model.InstanceFleetType;
import software.amazon.awssdk.services.emr.model.InstanceTypeConfig;
import software.amazon.awssdk.services.emr.model.InstanceTypeConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceFleetConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceFleetConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceFleetConfig.getter(InstanceFleetConfig::name)).setter(InstanceFleetConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> INSTANCE_FLEET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceFleetConfig.getter(InstanceFleetConfig::instanceFleetTypeAsString)).setter(InstanceFleetConfig.setter(Builder::instanceFleetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleetType").build()}).build();
    private static final SdkField<Integer> TARGET_ON_DEMAND_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(InstanceFleetConfig.getter(InstanceFleetConfig::targetOnDemandCapacity)).setter(InstanceFleetConfig.setter(Builder::targetOnDemandCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOnDemandCapacity").build()}).build();
    private static final SdkField<Integer> TARGET_SPOT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(InstanceFleetConfig.getter(InstanceFleetConfig::targetSpotCapacity)).setter(InstanceFleetConfig.setter(Builder::targetSpotCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSpotCapacity").build()}).build();
    private static final SdkField<List<InstanceTypeConfig>> INSTANCE_TYPE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceFleetConfig.getter(InstanceFleetConfig::instanceTypeConfigs)).setter(InstanceFleetConfig.setter(Builder::instanceTypeConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypeConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceTypeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceFleetProvisioningSpecifications> LAUNCH_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InstanceFleetConfig.getter(InstanceFleetConfig::launchSpecifications)).setter(InstanceFleetConfig.setter(Builder::launchSpecifications)).constructor(InstanceFleetProvisioningSpecifications::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchSpecifications").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INSTANCE_FLEET_TYPE_FIELD, TARGET_ON_DEMAND_CAPACITY_FIELD, TARGET_SPOT_CAPACITY_FIELD, INSTANCE_TYPE_CONFIGS_FIELD, LAUNCH_SPECIFICATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String instanceFleetType;
    private final Integer targetOnDemandCapacity;
    private final Integer targetSpotCapacity;
    private final List<InstanceTypeConfig> instanceTypeConfigs;
    private final InstanceFleetProvisioningSpecifications launchSpecifications;

    private InstanceFleetConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.instanceFleetType = builder.instanceFleetType;
        this.targetOnDemandCapacity = builder.targetOnDemandCapacity;
        this.targetSpotCapacity = builder.targetSpotCapacity;
        this.instanceTypeConfigs = builder.instanceTypeConfigs;
        this.launchSpecifications = builder.launchSpecifications;
    }

    public String name() {
        return this.name;
    }

    public InstanceFleetType instanceFleetType() {
        return InstanceFleetType.fromValue(this.instanceFleetType);
    }

    public String instanceFleetTypeAsString() {
        return this.instanceFleetType;
    }

    public Integer targetOnDemandCapacity() {
        return this.targetOnDemandCapacity;
    }

    public Integer targetSpotCapacity() {
        return this.targetSpotCapacity;
    }

    public List<InstanceTypeConfig> instanceTypeConfigs() {
        return this.instanceTypeConfigs;
    }

    public InstanceFleetProvisioningSpecifications launchSpecifications() {
        return this.launchSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetOnDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSpotCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchSpecifications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetConfig)) {
            return false;
        }
        InstanceFleetConfig other = (InstanceFleetConfig)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.instanceFleetTypeAsString(), other.instanceFleetTypeAsString()) && Objects.equals(this.targetOnDemandCapacity(), other.targetOnDemandCapacity()) && Objects.equals(this.targetSpotCapacity(), other.targetSpotCapacity()) && Objects.equals(this.instanceTypeConfigs(), other.instanceTypeConfigs()) && Objects.equals(this.launchSpecifications(), other.launchSpecifications());
    }

    public String toString() {
        return ToString.builder((String)"InstanceFleetConfig").add("Name", (Object)this.name()).add("InstanceFleetType", (Object)this.instanceFleetTypeAsString()).add("TargetOnDemandCapacity", (Object)this.targetOnDemandCapacity()).add("TargetSpotCapacity", (Object)this.targetSpotCapacity()).add("InstanceTypeConfigs", this.instanceTypeConfigs()).add("LaunchSpecifications", (Object)this.launchSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "InstanceFleetType": {
                return Optional.ofNullable(clazz.cast(this.instanceFleetTypeAsString()));
            }
            case "TargetOnDemandCapacity": {
                return Optional.ofNullable(clazz.cast(this.targetOnDemandCapacity()));
            }
            case "TargetSpotCapacity": {
                return Optional.ofNullable(clazz.cast(this.targetSpotCapacity()));
            }
            case "InstanceTypeConfigs": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeConfigs()));
            }
            case "LaunchSpecifications": {
                return Optional.ofNullable(clazz.cast(this.launchSpecifications()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceFleetConfig, T> g) {
        return obj -> g.apply((InstanceFleetConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String instanceFleetType;
        private Integer targetOnDemandCapacity;
        private Integer targetSpotCapacity;
        private List<InstanceTypeConfig> instanceTypeConfigs = DefaultSdkAutoConstructList.getInstance();
        private InstanceFleetProvisioningSpecifications launchSpecifications;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetConfig model) {
            this.name(model.name);
            this.instanceFleetType(model.instanceFleetType);
            this.targetOnDemandCapacity(model.targetOnDemandCapacity);
            this.targetSpotCapacity(model.targetSpotCapacity);
            this.instanceTypeConfigs(model.instanceTypeConfigs);
            this.launchSpecifications(model.launchSpecifications);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInstanceFleetTypeAsString() {
            return this.instanceFleetType;
        }

        @Override
        public final Builder instanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
            return this;
        }

        @Override
        public final Builder instanceFleetType(InstanceFleetType instanceFleetType) {
            this.instanceFleetType(instanceFleetType.toString());
            return this;
        }

        public final void setInstanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
        }

        public final Integer getTargetOnDemandCapacity() {
            return this.targetOnDemandCapacity;
        }

        @Override
        public final Builder targetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
            return this;
        }

        public final void setTargetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
        }

        public final Integer getTargetSpotCapacity() {
            return this.targetSpotCapacity;
        }

        @Override
        public final Builder targetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
            return this;
        }

        public final void setTargetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
        }

        public final Collection<InstanceTypeConfig.Builder> getInstanceTypeConfigs() {
            return this.instanceTypeConfigs != null ? (Collection)this.instanceTypeConfigs.stream().map(InstanceTypeConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceTypeConfigs(Collection<InstanceTypeConfig> instanceTypeConfigs) {
            this.instanceTypeConfigs = InstanceTypeConfigListCopier.copy(instanceTypeConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeConfigs(InstanceTypeConfig ... instanceTypeConfigs) {
            this.instanceTypeConfigs(Arrays.asList(instanceTypeConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeConfigs(Consumer<InstanceTypeConfig.Builder> ... instanceTypeConfigs) {
            this.instanceTypeConfigs(Stream.of(instanceTypeConfigs).map(c -> (InstanceTypeConfig)((InstanceTypeConfig.Builder)InstanceTypeConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceTypeConfigs(Collection<InstanceTypeConfig.BuilderImpl> instanceTypeConfigs) {
            this.instanceTypeConfigs = InstanceTypeConfigListCopier.copyFromBuilder(instanceTypeConfigs);
        }

        public final InstanceFleetProvisioningSpecifications.Builder getLaunchSpecifications() {
            return this.launchSpecifications != null ? this.launchSpecifications.toBuilder() : null;
        }

        @Override
        public final Builder launchSpecifications(InstanceFleetProvisioningSpecifications launchSpecifications) {
            this.launchSpecifications = launchSpecifications;
            return this;
        }

        public final void setLaunchSpecifications(InstanceFleetProvisioningSpecifications.BuilderImpl launchSpecifications) {
            this.launchSpecifications = launchSpecifications != null ? launchSpecifications.build() : null;
        }

        public InstanceFleetConfig build() {
            return new InstanceFleetConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceFleetConfig> {
        public Builder name(String var1);

        public Builder instanceFleetType(String var1);

        public Builder instanceFleetType(InstanceFleetType var1);

        public Builder targetOnDemandCapacity(Integer var1);

        public Builder targetSpotCapacity(Integer var1);

        public Builder instanceTypeConfigs(Collection<InstanceTypeConfig> var1);

        public Builder instanceTypeConfigs(InstanceTypeConfig ... var1);

        public Builder instanceTypeConfigs(Consumer<InstanceTypeConfig.Builder> ... var1);

        public Builder launchSpecifications(InstanceFleetProvisioningSpecifications var1);

        default public Builder launchSpecifications(Consumer<InstanceFleetProvisioningSpecifications.Builder> launchSpecifications) {
            return this.launchSpecifications((InstanceFleetProvisioningSpecifications)((InstanceFleetProvisioningSpecifications.Builder)InstanceFleetProvisioningSpecifications.builder().applyMutation(launchSpecifications)).build());
        }
    }
}

