/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InstanceState {
    AWAITING_FULFILLMENT("AWAITING_FULFILLMENT"),
    PROVISIONING("PROVISIONING"),
    BOOTSTRAPPING("BOOTSTRAPPING"),
    RUNNING("RUNNING"),
    TERMINATED("TERMINATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InstanceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InstanceState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceState> knownValues() {
        return Stream.of(InstanceState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

