/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.ActionOnFailure;
import software.amazon.awssdk.services.emr.model.HadoopJarStepConfig;
import software.amazon.awssdk.services.emr.model.StepMonitoringConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StepConfig.getter(StepConfig::name)).setter(StepConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ACTION_ON_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionOnFailure").getter(StepConfig.getter(StepConfig::actionOnFailureAsString)).setter(StepConfig.setter(Builder::actionOnFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionOnFailure").build()}).build();
    private static final SdkField<HadoopJarStepConfig> HADOOP_JAR_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HadoopJarStep").getter(StepConfig.getter(StepConfig::hadoopJarStep)).setter(StepConfig.setter(Builder::hadoopJarStep)).constructor(HadoopJarStepConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HadoopJarStep").build()}).build();
    private static final SdkField<StepMonitoringConfiguration> STEP_MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StepMonitoringConfiguration").getter(StepConfig.getter(StepConfig::stepMonitoringConfiguration)).setter(StepConfig.setter(Builder::stepMonitoringConfiguration)).constructor(StepMonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepMonitoringConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ACTION_ON_FAILURE_FIELD, HADOOP_JAR_STEP_FIELD, STEP_MONITORING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StepConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String actionOnFailure;
    private final HadoopJarStepConfig hadoopJarStep;
    private final StepMonitoringConfiguration stepMonitoringConfiguration;

    private StepConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.actionOnFailure = builder.actionOnFailure;
        this.hadoopJarStep = builder.hadoopJarStep;
        this.stepMonitoringConfiguration = builder.stepMonitoringConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final ActionOnFailure actionOnFailure() {
        return ActionOnFailure.fromValue(this.actionOnFailure);
    }

    public final String actionOnFailureAsString() {
        return this.actionOnFailure;
    }

    public final HadoopJarStepConfig hadoopJarStep() {
        return this.hadoopJarStep;
    }

    public final StepMonitoringConfiguration stepMonitoringConfiguration() {
        return this.stepMonitoringConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionOnFailureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hadoopJarStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepMonitoringConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepConfig)) {
            return false;
        }
        StepConfig other = (StepConfig)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.actionOnFailureAsString(), other.actionOnFailureAsString()) && Objects.equals(this.hadoopJarStep(), other.hadoopJarStep()) && Objects.equals(this.stepMonitoringConfiguration(), other.stepMonitoringConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"StepConfig").add("Name", (Object)this.name()).add("ActionOnFailure", (Object)this.actionOnFailureAsString()).add("HadoopJarStep", (Object)this.hadoopJarStep()).add("StepMonitoringConfiguration", (Object)this.stepMonitoringConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ActionOnFailure": {
                return Optional.ofNullable(clazz.cast(this.actionOnFailureAsString()));
            }
            case "HadoopJarStep": {
                return Optional.ofNullable(clazz.cast(this.hadoopJarStep()));
            }
            case "StepMonitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.stepMonitoringConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("ActionOnFailure", ACTION_ON_FAILURE_FIELD);
        map.put("HadoopJarStep", HADOOP_JAR_STEP_FIELD);
        map.put("StepMonitoringConfiguration", STEP_MONITORING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StepConfig, T> g) {
        return obj -> g.apply((StepConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String actionOnFailure;
        private HadoopJarStepConfig hadoopJarStep;
        private StepMonitoringConfiguration stepMonitoringConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StepConfig model) {
            this.name(model.name);
            this.actionOnFailure(model.actionOnFailure);
            this.hadoopJarStep(model.hadoopJarStep);
            this.stepMonitoringConfiguration(model.stepMonitoringConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getActionOnFailure() {
            return this.actionOnFailure;
        }

        public final void setActionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
        }

        @Override
        public final Builder actionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
            return this;
        }

        @Override
        public final Builder actionOnFailure(ActionOnFailure actionOnFailure) {
            this.actionOnFailure(actionOnFailure == null ? null : actionOnFailure.toString());
            return this;
        }

        public final HadoopJarStepConfig.Builder getHadoopJarStep() {
            return this.hadoopJarStep != null ? this.hadoopJarStep.toBuilder() : null;
        }

        public final void setHadoopJarStep(HadoopJarStepConfig.BuilderImpl hadoopJarStep) {
            this.hadoopJarStep = hadoopJarStep != null ? hadoopJarStep.build() : null;
        }

        @Override
        public final Builder hadoopJarStep(HadoopJarStepConfig hadoopJarStep) {
            this.hadoopJarStep = hadoopJarStep;
            return this;
        }

        public final StepMonitoringConfiguration.Builder getStepMonitoringConfiguration() {
            return this.stepMonitoringConfiguration != null ? this.stepMonitoringConfiguration.toBuilder() : null;
        }

        public final void setStepMonitoringConfiguration(StepMonitoringConfiguration.BuilderImpl stepMonitoringConfiguration) {
            this.stepMonitoringConfiguration = stepMonitoringConfiguration != null ? stepMonitoringConfiguration.build() : null;
        }

        @Override
        public final Builder stepMonitoringConfiguration(StepMonitoringConfiguration stepMonitoringConfiguration) {
            this.stepMonitoringConfiguration = stepMonitoringConfiguration;
            return this;
        }

        public StepConfig build() {
            return new StepConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepConfig> {
        public Builder name(String var1);

        public Builder actionOnFailure(String var1);

        public Builder actionOnFailure(ActionOnFailure var1);

        public Builder hadoopJarStep(HadoopJarStepConfig var1);

        default public Builder hadoopJarStep(Consumer<HadoopJarStepConfig.Builder> hadoopJarStep) {
            return this.hadoopJarStep((HadoopJarStepConfig)((HadoopJarStepConfig.Builder)HadoopJarStepConfig.builder().applyMutation(hadoopJarStep)).build());
        }

        public Builder stepMonitoringConfiguration(StepMonitoringConfiguration var1);

        default public Builder stepMonitoringConfiguration(Consumer<StepMonitoringConfiguration.Builder> stepMonitoringConfiguration) {
            return this.stepMonitoringConfiguration((StepMonitoringConfiguration)((StepMonitoringConfiguration.Builder)StepMonitoringConfiguration.builder().applyMutation(stepMonitoringConfiguration)).build());
        }
    }
}

