/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.ActionOnFailure;
import software.amazon.awssdk.services.emr.model.HadoopStepConfig;
import software.amazon.awssdk.services.emr.model.StepStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Step
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Step> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Step.getter(Step::id)).setter(Step.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Step.getter(Step::name)).setter(Step.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<HadoopStepConfig> CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Config").getter(Step.getter(Step::config)).setter(Step.setter(Builder::config)).constructor(HadoopStepConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build()}).build();
    private static final SdkField<String> ACTION_ON_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionOnFailure").getter(Step.getter(Step::actionOnFailureAsString)).setter(Step.setter(Builder::actionOnFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionOnFailure").build()}).build();
    private static final SdkField<StepStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(Step.getter(Step::status)).setter(Step.setter(Builder::status)).constructor(StepStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(Step.getter(Step::executionRoleArn)).setter(Step.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> LOG_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogUri").getter(Step.getter(Step::logUri)).setter(Step.setter(Builder::logUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogUri").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(Step.getter(Step::encryptionKeyArn)).setter(Step.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, CONFIG_FIELD, ACTION_ON_FAILURE_FIELD, STATUS_FIELD, EXECUTION_ROLE_ARN_FIELD, LOG_URI_FIELD, ENCRYPTION_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Step.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final HadoopStepConfig config;
    private final String actionOnFailure;
    private final StepStatus status;
    private final String executionRoleArn;
    private final String logUri;
    private final String encryptionKeyArn;

    private Step(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.config = builder.config;
        this.actionOnFailure = builder.actionOnFailure;
        this.status = builder.status;
        this.executionRoleArn = builder.executionRoleArn;
        this.logUri = builder.logUri;
        this.encryptionKeyArn = builder.encryptionKeyArn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final HadoopStepConfig config() {
        return this.config;
    }

    public final ActionOnFailure actionOnFailure() {
        return ActionOnFailure.fromValue(this.actionOnFailure);
    }

    public final String actionOnFailureAsString() {
        return this.actionOnFailure;
    }

    public final StepStatus status() {
        return this.status;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String logUri() {
        return this.logUri;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.config());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionOnFailureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step other = (Step)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.config(), other.config()) && Objects.equals(this.actionOnFailureAsString(), other.actionOnFailureAsString()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"Step").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Config", (Object)this.config()).add("ActionOnFailure", (Object)this.actionOnFailureAsString()).add("Status", (Object)this.status()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("LogUri", (Object)this.logUri()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Config": {
                return Optional.ofNullable(clazz.cast(this.config()));
            }
            case "ActionOnFailure": {
                return Optional.ofNullable(clazz.cast(this.actionOnFailureAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "LogUri": {
                return Optional.ofNullable(clazz.cast(this.logUri()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Config", CONFIG_FIELD);
        map.put("ActionOnFailure", ACTION_ON_FAILURE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("LogUri", LOG_URI_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Step, T> g) {
        return obj -> g.apply((Step)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private HadoopStepConfig config;
        private String actionOnFailure;
        private StepStatus status;
        private String executionRoleArn;
        private String logUri;
        private String encryptionKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Step model) {
            this.id(model.id);
            this.name(model.name);
            this.config(model.config);
            this.actionOnFailure(model.actionOnFailure);
            this.status(model.status);
            this.executionRoleArn(model.executionRoleArn);
            this.logUri(model.logUri);
            this.encryptionKeyArn(model.encryptionKeyArn);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final HadoopStepConfig.Builder getConfig() {
            return this.config != null ? this.config.toBuilder() : null;
        }

        public final void setConfig(HadoopStepConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        @Override
        public final Builder config(HadoopStepConfig config) {
            this.config = config;
            return this;
        }

        public final String getActionOnFailure() {
            return this.actionOnFailure;
        }

        public final void setActionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
        }

        @Override
        public final Builder actionOnFailure(String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
            return this;
        }

        @Override
        public final Builder actionOnFailure(ActionOnFailure actionOnFailure) {
            this.actionOnFailure(actionOnFailure == null ? null : actionOnFailure.toString());
            return this;
        }

        public final StepStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(StepStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(StepStatus status) {
            this.status = status;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public Step build() {
            return new Step(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Step> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder config(HadoopStepConfig var1);

        default public Builder config(Consumer<HadoopStepConfig.Builder> config) {
            return this.config((HadoopStepConfig)((HadoopStepConfig.Builder)HadoopStepConfig.builder().applyMutation(config)).build());
        }

        public Builder actionOnFailure(String var1);

        public Builder actionOnFailure(ActionOnFailure var1);

        public Builder status(StepStatus var1);

        default public Builder status(Consumer<StepStatus.Builder> status) {
            return this.status((StepStatus)((StepStatus.Builder)StepStatus.builder().applyMutation(status)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder logUri(String var1);

        public Builder encryptionKeyArn(String var1);
    }
}

