/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.PersistentAppUIType;
import software.amazon.awssdk.services.emr.model.PersistentAppUITypeListCopier;
import software.amazon.awssdk.services.emr.model.Tag;
import software.amazon.awssdk.services.emr.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PersistentAppUI
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PersistentAppUI> {
    private static final SdkField<String> PERSISTENT_APP_UI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PersistentAppUIId").getter(PersistentAppUI.getter(PersistentAppUI::persistentAppUIId)).setter(PersistentAppUI.setter(Builder::persistentAppUIId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistentAppUIId").build()}).build();
    private static final SdkField<List<String>> PERSISTENT_APP_UI_TYPE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PersistentAppUITypeList").getter(PersistentAppUI.getter(PersistentAppUI::persistentAppUITypeListAsStrings)).setter(PersistentAppUI.setter(Builder::persistentAppUITypeListWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistentAppUITypeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PERSISTENT_APP_UI_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PersistentAppUIStatus").getter(PersistentAppUI.getter(PersistentAppUI::persistentAppUIStatus)).setter(PersistentAppUI.setter(Builder::persistentAppUIStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistentAppUIStatus").build()}).build();
    private static final SdkField<String> AUTHOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorId").getter(PersistentAppUI.getter(PersistentAppUI::authorId)).setter(PersistentAppUI.setter(Builder::authorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(PersistentAppUI.getter(PersistentAppUI::creationTime)).setter(PersistentAppUI.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(PersistentAppUI.getter(PersistentAppUI::lastModifiedTime)).setter(PersistentAppUI.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastStateChangeReason").getter(PersistentAppUI.getter(PersistentAppUI::lastStateChangeReason)).setter(PersistentAppUI.setter(Builder::lastStateChangeReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStateChangeReason").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PersistentAppUI.getter(PersistentAppUI::tags)).setter(PersistentAppUI.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSISTENT_APP_UI_ID_FIELD, PERSISTENT_APP_UI_TYPE_LIST_FIELD, PERSISTENT_APP_UI_STATUS_FIELD, AUTHOR_ID_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_STATE_CHANGE_REASON_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PersistentAppUI.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String persistentAppUIId;
    private final List<String> persistentAppUITypeList;
    private final String persistentAppUIStatus;
    private final String authorId;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String lastStateChangeReason;
    private final List<Tag> tags;

    private PersistentAppUI(BuilderImpl builder) {
        this.persistentAppUIId = builder.persistentAppUIId;
        this.persistentAppUITypeList = builder.persistentAppUITypeList;
        this.persistentAppUIStatus = builder.persistentAppUIStatus;
        this.authorId = builder.authorId;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastStateChangeReason = builder.lastStateChangeReason;
        this.tags = builder.tags;
    }

    public final String persistentAppUIId() {
        return this.persistentAppUIId;
    }

    public final List<PersistentAppUIType> persistentAppUITypeList() {
        return PersistentAppUITypeListCopier.copyStringToEnum(this.persistentAppUITypeList);
    }

    public final boolean hasPersistentAppUITypeList() {
        return this.persistentAppUITypeList != null && !(this.persistentAppUITypeList instanceof SdkAutoConstructList);
    }

    public final List<String> persistentAppUITypeListAsStrings() {
        return this.persistentAppUITypeList;
    }

    public final String persistentAppUIStatus() {
        return this.persistentAppUIStatus;
    }

    public final String authorId() {
        return this.authorId;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastStateChangeReason() {
        return this.lastStateChangeReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.persistentAppUIId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPersistentAppUITypeList() ? this.persistentAppUITypeListAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.persistentAppUIStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersistentAppUI)) {
            return false;
        }
        PersistentAppUI other = (PersistentAppUI)obj;
        return Objects.equals(this.persistentAppUIId(), other.persistentAppUIId()) && this.hasPersistentAppUITypeList() == other.hasPersistentAppUITypeList() && Objects.equals(this.persistentAppUITypeListAsStrings(), other.persistentAppUITypeListAsStrings()) && Objects.equals(this.persistentAppUIStatus(), other.persistentAppUIStatus()) && Objects.equals(this.authorId(), other.authorId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastStateChangeReason(), other.lastStateChangeReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PersistentAppUI").add("PersistentAppUIId", (Object)this.persistentAppUIId()).add("PersistentAppUITypeList", this.hasPersistentAppUITypeList() ? this.persistentAppUITypeListAsStrings() : null).add("PersistentAppUIStatus", (Object)this.persistentAppUIStatus()).add("AuthorId", (Object)this.authorId()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastStateChangeReason", (Object)this.lastStateChangeReason()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PersistentAppUIId": {
                return Optional.ofNullable(clazz.cast(this.persistentAppUIId()));
            }
            case "PersistentAppUITypeList": {
                return Optional.ofNullable(clazz.cast(this.persistentAppUITypeListAsStrings()));
            }
            case "PersistentAppUIStatus": {
                return Optional.ofNullable(clazz.cast(this.persistentAppUIStatus()));
            }
            case "AuthorId": {
                return Optional.ofNullable(clazz.cast(this.authorId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastStateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.lastStateChangeReason()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PersistentAppUIId", PERSISTENT_APP_UI_ID_FIELD);
        map.put("PersistentAppUITypeList", PERSISTENT_APP_UI_TYPE_LIST_FIELD);
        map.put("PersistentAppUIStatus", PERSISTENT_APP_UI_STATUS_FIELD);
        map.put("AuthorId", AUTHOR_ID_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastStateChangeReason", LAST_STATE_CHANGE_REASON_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PersistentAppUI, T> g) {
        return obj -> g.apply((PersistentAppUI)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String persistentAppUIId;
        private List<String> persistentAppUITypeList = DefaultSdkAutoConstructList.getInstance();
        private String persistentAppUIStatus;
        private String authorId;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String lastStateChangeReason;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PersistentAppUI model) {
            this.persistentAppUIId(model.persistentAppUIId);
            this.persistentAppUITypeListWithStrings(model.persistentAppUITypeList);
            this.persistentAppUIStatus(model.persistentAppUIStatus);
            this.authorId(model.authorId);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastStateChangeReason(model.lastStateChangeReason);
            this.tags(model.tags);
        }

        public final String getPersistentAppUIId() {
            return this.persistentAppUIId;
        }

        public final void setPersistentAppUIId(String persistentAppUIId) {
            this.persistentAppUIId = persistentAppUIId;
        }

        @Override
        public final Builder persistentAppUIId(String persistentAppUIId) {
            this.persistentAppUIId = persistentAppUIId;
            return this;
        }

        public final Collection<String> getPersistentAppUITypeList() {
            if (this.persistentAppUITypeList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.persistentAppUITypeList;
        }

        public final void setPersistentAppUITypeList(Collection<String> persistentAppUITypeList) {
            this.persistentAppUITypeList = PersistentAppUITypeListCopier.copy(persistentAppUITypeList);
        }

        @Override
        public final Builder persistentAppUITypeListWithStrings(Collection<String> persistentAppUITypeList) {
            this.persistentAppUITypeList = PersistentAppUITypeListCopier.copy(persistentAppUITypeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persistentAppUITypeListWithStrings(String ... persistentAppUITypeList) {
            this.persistentAppUITypeListWithStrings(Arrays.asList(persistentAppUITypeList));
            return this;
        }

        @Override
        public final Builder persistentAppUITypeList(Collection<PersistentAppUIType> persistentAppUITypeList) {
            this.persistentAppUITypeList = PersistentAppUITypeListCopier.copyEnumToString(persistentAppUITypeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persistentAppUITypeList(PersistentAppUIType ... persistentAppUITypeList) {
            this.persistentAppUITypeList(Arrays.asList(persistentAppUITypeList));
            return this;
        }

        public final String getPersistentAppUIStatus() {
            return this.persistentAppUIStatus;
        }

        public final void setPersistentAppUIStatus(String persistentAppUIStatus) {
            this.persistentAppUIStatus = persistentAppUIStatus;
        }

        @Override
        public final Builder persistentAppUIStatus(String persistentAppUIStatus) {
            this.persistentAppUIStatus = persistentAppUIStatus;
            return this;
        }

        public final String getAuthorId() {
            return this.authorId;
        }

        public final void setAuthorId(String authorId) {
            this.authorId = authorId;
        }

        @Override
        public final Builder authorId(String authorId) {
            this.authorId = authorId;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastStateChangeReason() {
            return this.lastStateChangeReason;
        }

        public final void setLastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
        }

        @Override
        public final Builder lastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PersistentAppUI build() {
            return new PersistentAppUI(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PersistentAppUI> {
        public Builder persistentAppUIId(String var1);

        public Builder persistentAppUITypeListWithStrings(Collection<String> var1);

        public Builder persistentAppUITypeListWithStrings(String ... var1);

        public Builder persistentAppUITypeList(Collection<PersistentAppUIType> var1);

        public Builder persistentAppUITypeList(PersistentAppUIType ... var1);

        public Builder persistentAppUIStatus(String var1);

        public Builder authorId(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastStateChangeReason(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

