/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SpotProvisioningAllocationStrategy {
    CAPACITY_OPTIMIZED("capacity-optimized"),
    PRICE_CAPACITY_OPTIMIZED("price-capacity-optimized"),
    LOWEST_PRICE("lowest-price"),
    DIVERSIFIED("diversified"),
    CAPACITY_OPTIMIZED_PRIORITIZED("capacity-optimized-prioritized"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SpotProvisioningAllocationStrategy> VALUE_MAP;
    private final String value;

    private SpotProvisioningAllocationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SpotProvisioningAllocationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SpotProvisioningAllocationStrategy> knownValues() {
        EnumSet<SpotProvisioningAllocationStrategy> knownValues = EnumSet.allOf(SpotProvisioningAllocationStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SpotProvisioningAllocationStrategy.class, SpotProvisioningAllocationStrategy::toString);
    }
}

