/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.SessionMappingSummary;
import software.amazon.awssdk.services.emr.model.SessionMappingSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStudioSessionMappingsResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, ListStudioSessionMappingsResponse> {
    private static final SdkField<List<SessionMappingSummary>> SESSION_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SessionMappings").getter(ListStudioSessionMappingsResponse.getter(ListStudioSessionMappingsResponse::sessionMappings)).setter(ListStudioSessionMappingsResponse.setter(Builder::sessionMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SessionMappingSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListStudioSessionMappingsResponse.getter(ListStudioSessionMappingsResponse::marker)).setter(ListStudioSessionMappingsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_MAPPINGS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListStudioSessionMappingsResponse.memberNameToFieldInitializer();
    private final List<SessionMappingSummary> sessionMappings;
    private final String marker;

    private ListStudioSessionMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.sessionMappings = builder.sessionMappings;
        this.marker = builder.marker;
    }

    public final boolean hasSessionMappings() {
        return this.sessionMappings != null && !(this.sessionMappings instanceof SdkAutoConstructList);
    }

    public final List<SessionMappingSummary> sessionMappings() {
        return this.sessionMappings;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionMappings() ? this.sessionMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStudioSessionMappingsResponse)) {
            return false;
        }
        ListStudioSessionMappingsResponse other = (ListStudioSessionMappingsResponse)((Object)obj);
        return this.hasSessionMappings() == other.hasSessionMappings() && Objects.equals(this.sessionMappings(), other.sessionMappings()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListStudioSessionMappingsResponse").add("SessionMappings", this.hasSessionMappings() ? this.sessionMappings() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionMappings": {
                return Optional.ofNullable(clazz.cast(this.sessionMappings()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SessionMappings", SESSION_MAPPINGS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStudioSessionMappingsResponse, T> g) {
        return obj -> g.apply((ListStudioSessionMappingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<SessionMappingSummary> sessionMappings = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStudioSessionMappingsResponse model) {
            super(model);
            this.sessionMappings(model.sessionMappings);
            this.marker(model.marker);
        }

        public final List<SessionMappingSummary.Builder> getSessionMappings() {
            List<SessionMappingSummary.Builder> result = SessionMappingSummaryListCopier.copyToBuilder(this.sessionMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionMappings(Collection<SessionMappingSummary.BuilderImpl> sessionMappings) {
            this.sessionMappings = SessionMappingSummaryListCopier.copyFromBuilder(sessionMappings);
        }

        @Override
        public final Builder sessionMappings(Collection<SessionMappingSummary> sessionMappings) {
            this.sessionMappings = SessionMappingSummaryListCopier.copy(sessionMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionMappings(SessionMappingSummary ... sessionMappings) {
            this.sessionMappings(Arrays.asList(sessionMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionMappings(Consumer<SessionMappingSummary.Builder> ... sessionMappings) {
            this.sessionMappings(Stream.of(sessionMappings).map(c -> (SessionMappingSummary)((SessionMappingSummary.Builder)SessionMappingSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListStudioSessionMappingsResponse build() {
            return new ListStudioSessionMappingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStudioSessionMappingsResponse> {
        public Builder sessionMappings(Collection<SessionMappingSummary> var1);

        public Builder sessionMappings(SessionMappingSummary ... var1);

        public Builder sessionMappings(Consumer<SessionMappingSummary.Builder> ... var1);

        public Builder marker(String var1);
    }
}

