/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EbsVolume;
import software.amazon.awssdk.services.emr.model.EbsVolumeListCopier;
import software.amazon.awssdk.services.emr.model.InstanceStatus;
import software.amazon.awssdk.services.emr.model.MarketType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Instance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Instance> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Instance.getter(Instance::id)).setter(Instance.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2InstanceId").getter(Instance.getter(Instance::ec2InstanceId)).setter(Instance.setter(Builder::ec2InstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()}).build();
    private static final SdkField<String> PUBLIC_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicDnsName").getter(Instance.getter(Instance::publicDnsName)).setter(Instance.setter(Builder::publicDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicDnsName").build()}).build();
    private static final SdkField<String> PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIpAddress").getter(Instance.getter(Instance::publicIpAddress)).setter(Instance.setter(Builder::publicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpAddress").build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDnsName").getter(Instance.getter(Instance::privateDnsName)).setter(Instance.setter(Builder::privateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIpAddress").getter(Instance.getter(Instance::privateIpAddress)).setter(Instance.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").build()}).build();
    private static final SdkField<InstanceStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(Instance.getter(Instance::status)).setter(Instance.setter(Builder::status)).constructor(InstanceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> INSTANCE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupId").getter(Instance.getter(Instance::instanceGroupId)).setter(Instance.setter(Builder::instanceGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupId").build()}).build();
    private static final SdkField<String> INSTANCE_FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFleetId").getter(Instance.getter(Instance::instanceFleetId)).setter(Instance.setter(Builder::instanceFleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleetId").build()}).build();
    private static final SdkField<String> MARKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Market").getter(Instance.getter(Instance::marketAsString)).setter(Instance.setter(Builder::market)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Market").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(Instance.getter(Instance::instanceType)).setter(Instance.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<List<EbsVolume>> EBS_VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EbsVolumes").getter(Instance.getter(Instance::ebsVolumes)).setter(Instance.setter(Builder::ebsVolumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsVolumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EbsVolume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EC2_INSTANCE_ID_FIELD, PUBLIC_DNS_NAME_FIELD, PUBLIC_IP_ADDRESS_FIELD, PRIVATE_DNS_NAME_FIELD, PRIVATE_IP_ADDRESS_FIELD, STATUS_FIELD, INSTANCE_GROUP_ID_FIELD, INSTANCE_FLEET_ID_FIELD, MARKET_FIELD, INSTANCE_TYPE_FIELD, EBS_VOLUMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Instance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String ec2InstanceId;
    private final String publicDnsName;
    private final String publicIpAddress;
    private final String privateDnsName;
    private final String privateIpAddress;
    private final InstanceStatus status;
    private final String instanceGroupId;
    private final String instanceFleetId;
    private final String market;
    private final String instanceType;
    private final List<EbsVolume> ebsVolumes;

    private Instance(BuilderImpl builder) {
        this.id = builder.id;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.publicDnsName = builder.publicDnsName;
        this.publicIpAddress = builder.publicIpAddress;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.status = builder.status;
        this.instanceGroupId = builder.instanceGroupId;
        this.instanceFleetId = builder.instanceFleetId;
        this.market = builder.market;
        this.instanceType = builder.instanceType;
        this.ebsVolumes = builder.ebsVolumes;
    }

    public final String id() {
        return this.id;
    }

    public final String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public final String publicDnsName() {
        return this.publicDnsName;
    }

    public final String publicIpAddress() {
        return this.publicIpAddress;
    }

    public final String privateDnsName() {
        return this.privateDnsName;
    }

    public final String privateIpAddress() {
        return this.privateIpAddress;
    }

    public final InstanceStatus status() {
        return this.status;
    }

    public final String instanceGroupId() {
        return this.instanceGroupId;
    }

    public final String instanceFleetId() {
        return this.instanceFleetId;
    }

    public final MarketType market() {
        return MarketType.fromValue(this.market);
    }

    public final String marketAsString() {
        return this.market;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final boolean hasEbsVolumes() {
        return this.ebsVolumes != null && !(this.ebsVolumes instanceof SdkAutoConstructList);
    }

    public final List<EbsVolume> ebsVolumes() {
        return this.ebsVolumes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEbsVolumes() ? this.ebsVolumes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.publicDnsName(), other.publicDnsName()) && Objects.equals(this.publicIpAddress(), other.publicIpAddress()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.instanceGroupId(), other.instanceGroupId()) && Objects.equals(this.instanceFleetId(), other.instanceFleetId()) && Objects.equals(this.marketAsString(), other.marketAsString()) && Objects.equals(this.instanceType(), other.instanceType()) && this.hasEbsVolumes() == other.hasEbsVolumes() && Objects.equals(this.ebsVolumes(), other.ebsVolumes());
    }

    public final String toString() {
        return ToString.builder((String)"Instance").add("Id", (Object)this.id()).add("Ec2InstanceId", (Object)this.ec2InstanceId()).add("PublicDnsName", (Object)this.publicDnsName()).add("PublicIpAddress", (Object)this.publicIpAddress()).add("PrivateDnsName", (Object)this.privateDnsName()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("Status", (Object)this.status()).add("InstanceGroupId", (Object)this.instanceGroupId()).add("InstanceFleetId", (Object)this.instanceFleetId()).add("Market", (Object)this.marketAsString()).add("InstanceType", (Object)this.instanceType()).add("EbsVolumes", this.hasEbsVolumes() ? this.ebsVolumes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Ec2InstanceId": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceId()));
            }
            case "PublicDnsName": {
                return Optional.ofNullable(clazz.cast(this.publicDnsName()));
            }
            case "PublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.publicIpAddress()));
            }
            case "PrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.privateDnsName()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "InstanceGroupId": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupId()));
            }
            case "InstanceFleetId": {
                return Optional.ofNullable(clazz.cast(this.instanceFleetId()));
            }
            case "Market": {
                return Optional.ofNullable(clazz.cast(this.marketAsString()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "EbsVolumes": {
                return Optional.ofNullable(clazz.cast(this.ebsVolumes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Ec2InstanceId", EC2_INSTANCE_ID_FIELD);
        map.put("PublicDnsName", PUBLIC_DNS_NAME_FIELD);
        map.put("PublicIpAddress", PUBLIC_IP_ADDRESS_FIELD);
        map.put("PrivateDnsName", PRIVATE_DNS_NAME_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("InstanceGroupId", INSTANCE_GROUP_ID_FIELD);
        map.put("InstanceFleetId", INSTANCE_FLEET_ID_FIELD);
        map.put("Market", MARKET_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("EbsVolumes", EBS_VOLUMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String ec2InstanceId;
        private String publicDnsName;
        private String publicIpAddress;
        private String privateDnsName;
        private String privateIpAddress;
        private InstanceStatus status;
        private String instanceGroupId;
        private String instanceFleetId;
        private String market;
        private String instanceType;
        private List<EbsVolume> ebsVolumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.id(model.id);
            this.ec2InstanceId(model.ec2InstanceId);
            this.publicDnsName(model.publicDnsName);
            this.publicIpAddress(model.publicIpAddress);
            this.privateDnsName(model.privateDnsName);
            this.privateIpAddress(model.privateIpAddress);
            this.status(model.status);
            this.instanceGroupId(model.instanceGroupId);
            this.instanceFleetId(model.instanceFleetId);
            this.market(model.market);
            this.instanceType(model.instanceType);
            this.ebsVolumes(model.ebsVolumes);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final String getPublicDnsName() {
            return this.publicDnsName;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final String getPublicIpAddress() {
            return this.publicIpAddress;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final InstanceStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(InstanceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(InstanceStatus status) {
            this.status = status;
            return this;
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final String getInstanceFleetId() {
            return this.instanceFleetId;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        @Override
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final String getMarket() {
            return this.market;
        }

        public final void setMarket(String market) {
            this.market = market;
        }

        @Override
        public final Builder market(String market) {
            this.market = market;
            return this;
        }

        @Override
        public final Builder market(MarketType market) {
            this.market(market == null ? null : market.toString());
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final List<EbsVolume.Builder> getEbsVolumes() {
            List<EbsVolume.Builder> result = EbsVolumeListCopier.copyToBuilder(this.ebsVolumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEbsVolumes(Collection<EbsVolume.BuilderImpl> ebsVolumes) {
            this.ebsVolumes = EbsVolumeListCopier.copyFromBuilder(ebsVolumes);
        }

        @Override
        public final Builder ebsVolumes(Collection<EbsVolume> ebsVolumes) {
            this.ebsVolumes = EbsVolumeListCopier.copy(ebsVolumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsVolumes(EbsVolume ... ebsVolumes) {
            this.ebsVolumes(Arrays.asList(ebsVolumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsVolumes(Consumer<EbsVolume.Builder> ... ebsVolumes) {
            this.ebsVolumes(Stream.of(ebsVolumes).map(c -> (EbsVolume)((EbsVolume.Builder)EbsVolume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Instance build() {
            return new Instance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Instance> {
        public Builder id(String var1);

        public Builder ec2InstanceId(String var1);

        public Builder publicDnsName(String var1);

        public Builder publicIpAddress(String var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);

        public Builder status(InstanceStatus var1);

        default public Builder status(Consumer<InstanceStatus.Builder> status) {
            return this.status((InstanceStatus)((InstanceStatus.Builder)InstanceStatus.builder().applyMutation(status)).build());
        }

        public Builder instanceGroupId(String var1);

        public Builder instanceFleetId(String var1);

        public Builder market(String var1);

        public Builder market(MarketType var1);

        public Builder instanceType(String var1);

        public Builder ebsVolumes(Collection<EbsVolume> var1);

        public Builder ebsVolumes(EbsVolume ... var1);

        public Builder ebsVolumes(Consumer<EbsVolume.Builder> ... var1);
    }
}

