/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.OnDemandProvisioningSpecification;
import software.amazon.awssdk.services.emr.model.SpotProvisioningSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceFleetProvisioningSpecifications
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceFleetProvisioningSpecifications> {
    private static final SdkField<SpotProvisioningSpecification> SPOT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpotSpecification").getter(InstanceFleetProvisioningSpecifications.getter(InstanceFleetProvisioningSpecifications::spotSpecification)).setter(InstanceFleetProvisioningSpecifications.setter(Builder::spotSpecification)).constructor(SpotProvisioningSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotSpecification").build()}).build();
    private static final SdkField<OnDemandProvisioningSpecification> ON_DEMAND_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnDemandSpecification").getter(InstanceFleetProvisioningSpecifications.getter(InstanceFleetProvisioningSpecifications::onDemandSpecification)).setter(InstanceFleetProvisioningSpecifications.setter(Builder::onDemandSpecification)).constructor(OnDemandProvisioningSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_SPECIFICATION_FIELD, ON_DEMAND_SPECIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceFleetProvisioningSpecifications.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SpotProvisioningSpecification spotSpecification;
    private final OnDemandProvisioningSpecification onDemandSpecification;

    private InstanceFleetProvisioningSpecifications(BuilderImpl builder) {
        this.spotSpecification = builder.spotSpecification;
        this.onDemandSpecification = builder.onDemandSpecification;
    }

    public final SpotProvisioningSpecification spotSpecification() {
        return this.spotSpecification;
    }

    public final OnDemandProvisioningSpecification onDemandSpecification() {
        return this.onDemandSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spotSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetProvisioningSpecifications)) {
            return false;
        }
        InstanceFleetProvisioningSpecifications other = (InstanceFleetProvisioningSpecifications)obj;
        return Objects.equals(this.spotSpecification(), other.spotSpecification()) && Objects.equals(this.onDemandSpecification(), other.onDemandSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceFleetProvisioningSpecifications").add("SpotSpecification", (Object)this.spotSpecification()).add("OnDemandSpecification", (Object)this.onDemandSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpotSpecification": {
                return Optional.ofNullable(clazz.cast(this.spotSpecification()));
            }
            case "OnDemandSpecification": {
                return Optional.ofNullable(clazz.cast(this.onDemandSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SpotSpecification", SPOT_SPECIFICATION_FIELD);
        map.put("OnDemandSpecification", ON_DEMAND_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceFleetProvisioningSpecifications, T> g) {
        return obj -> g.apply((InstanceFleetProvisioningSpecifications)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SpotProvisioningSpecification spotSpecification;
        private OnDemandProvisioningSpecification onDemandSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetProvisioningSpecifications model) {
            this.spotSpecification(model.spotSpecification);
            this.onDemandSpecification(model.onDemandSpecification);
        }

        public final SpotProvisioningSpecification.Builder getSpotSpecification() {
            return this.spotSpecification != null ? this.spotSpecification.toBuilder() : null;
        }

        public final void setSpotSpecification(SpotProvisioningSpecification.BuilderImpl spotSpecification) {
            this.spotSpecification = spotSpecification != null ? spotSpecification.build() : null;
        }

        @Override
        public final Builder spotSpecification(SpotProvisioningSpecification spotSpecification) {
            this.spotSpecification = spotSpecification;
            return this;
        }

        public final OnDemandProvisioningSpecification.Builder getOnDemandSpecification() {
            return this.onDemandSpecification != null ? this.onDemandSpecification.toBuilder() : null;
        }

        public final void setOnDemandSpecification(OnDemandProvisioningSpecification.BuilderImpl onDemandSpecification) {
            this.onDemandSpecification = onDemandSpecification != null ? onDemandSpecification.build() : null;
        }

        @Override
        public final Builder onDemandSpecification(OnDemandProvisioningSpecification onDemandSpecification) {
            this.onDemandSpecification = onDemandSpecification;
            return this;
        }

        public InstanceFleetProvisioningSpecifications build() {
            return new InstanceFleetProvisioningSpecifications(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceFleetProvisioningSpecifications> {
        public Builder spotSpecification(SpotProvisioningSpecification var1);

        default public Builder spotSpecification(Consumer<SpotProvisioningSpecification.Builder> spotSpecification) {
            return this.spotSpecification((SpotProvisioningSpecification)((SpotProvisioningSpecification.Builder)SpotProvisioningSpecification.builder().applyMutation(spotSpecification)).build());
        }

        public Builder onDemandSpecification(OnDemandProvisioningSpecification var1);

        default public Builder onDemandSpecification(Consumer<OnDemandProvisioningSpecification.Builder> onDemandSpecification) {
            return this.onDemandSpecification((OnDemandProvisioningSpecification)((OnDemandProvisioningSpecification.Builder)OnDemandProvisioningSpecification.builder().applyMutation(onDemandSpecification)).build());
        }
    }
}

