/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetKeepJobFlowAliveWhenNoStepsRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, SetKeepJobFlowAliveWhenNoStepsRequest> {
    private static final SdkField<List<String>> JOB_FLOW_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobFlowIds").getter(SetKeepJobFlowAliveWhenNoStepsRequest.getter(SetKeepJobFlowAliveWhenNoStepsRequest::jobFlowIds)).setter(SetKeepJobFlowAliveWhenNoStepsRequest.setter(Builder::jobFlowIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> KEEP_JOB_FLOW_ALIVE_WHEN_NO_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KeepJobFlowAliveWhenNoSteps").getter(SetKeepJobFlowAliveWhenNoStepsRequest.getter(SetKeepJobFlowAliveWhenNoStepsRequest::keepJobFlowAliveWhenNoSteps)).setter(SetKeepJobFlowAliveWhenNoStepsRequest.setter(Builder::keepJobFlowAliveWhenNoSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeepJobFlowAliveWhenNoSteps").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FLOW_IDS_FIELD, KEEP_JOB_FLOW_ALIVE_WHEN_NO_STEPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SetKeepJobFlowAliveWhenNoStepsRequest.memberNameToFieldInitializer();
    private final List<String> jobFlowIds;
    private final Boolean keepJobFlowAliveWhenNoSteps;

    private SetKeepJobFlowAliveWhenNoStepsRequest(BuilderImpl builder) {
        super(builder);
        this.jobFlowIds = builder.jobFlowIds;
        this.keepJobFlowAliveWhenNoSteps = builder.keepJobFlowAliveWhenNoSteps;
    }

    public final boolean hasJobFlowIds() {
        return this.jobFlowIds != null && !(this.jobFlowIds instanceof SdkAutoConstructList);
    }

    public final List<String> jobFlowIds() {
        return this.jobFlowIds;
    }

    public final Boolean keepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobFlowIds() ? this.jobFlowIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.keepJobFlowAliveWhenNoSteps());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetKeepJobFlowAliveWhenNoStepsRequest)) {
            return false;
        }
        SetKeepJobFlowAliveWhenNoStepsRequest other = (SetKeepJobFlowAliveWhenNoStepsRequest)((Object)obj);
        return this.hasJobFlowIds() == other.hasJobFlowIds() && Objects.equals(this.jobFlowIds(), other.jobFlowIds()) && Objects.equals(this.keepJobFlowAliveWhenNoSteps(), other.keepJobFlowAliveWhenNoSteps());
    }

    public final String toString() {
        return ToString.builder((String)"SetKeepJobFlowAliveWhenNoStepsRequest").add("JobFlowIds", this.hasJobFlowIds() ? this.jobFlowIds() : null).add("KeepJobFlowAliveWhenNoSteps", (Object)this.keepJobFlowAliveWhenNoSteps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobFlowIds": {
                return Optional.ofNullable(clazz.cast(this.jobFlowIds()));
            }
            case "KeepJobFlowAliveWhenNoSteps": {
                return Optional.ofNullable(clazz.cast(this.keepJobFlowAliveWhenNoSteps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobFlowIds", JOB_FLOW_IDS_FIELD);
        map.put("KeepJobFlowAliveWhenNoSteps", KEEP_JOB_FLOW_ALIVE_WHEN_NO_STEPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetKeepJobFlowAliveWhenNoStepsRequest, T> g) {
        return obj -> g.apply((SetKeepJobFlowAliveWhenNoStepsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private List<String> jobFlowIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean keepJobFlowAliveWhenNoSteps;

        private BuilderImpl() {
        }

        private BuilderImpl(SetKeepJobFlowAliveWhenNoStepsRequest model) {
            super(model);
            this.jobFlowIds(model.jobFlowIds);
            this.keepJobFlowAliveWhenNoSteps(model.keepJobFlowAliveWhenNoSteps);
        }

        public final Collection<String> getJobFlowIds() {
            if (this.jobFlowIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobFlowIds;
        }

        public final void setJobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
        }

        @Override
        public final Builder jobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowIds(String ... jobFlowIds) {
            this.jobFlowIds(Arrays.asList(jobFlowIds));
            return this;
        }

        public final Boolean getKeepJobFlowAliveWhenNoSteps() {
            return this.keepJobFlowAliveWhenNoSteps;
        }

        public final void setKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
            this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
        }

        @Override
        public final Builder keepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
            this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetKeepJobFlowAliveWhenNoStepsRequest build() {
            return new SetKeepJobFlowAliveWhenNoStepsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetKeepJobFlowAliveWhenNoStepsRequest> {
        public Builder jobFlowIds(Collection<String> var1);

        public Builder jobFlowIds(String ... var1);

        public Builder keepJobFlowAliveWhenNoSteps(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

