/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddInstanceFleetResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, AddInstanceFleetResponse> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(AddInstanceFleetResponse.getter(AddInstanceFleetResponse::clusterId)).setter(AddInstanceFleetResponse.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> INSTANCE_FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFleetId").getter(AddInstanceFleetResponse.getter(AddInstanceFleetResponse::instanceFleetId)).setter(AddInstanceFleetResponse.setter(Builder::instanceFleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleetId").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(AddInstanceFleetResponse.getter(AddInstanceFleetResponse::clusterArn)).setter(AddInstanceFleetResponse.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, INSTANCE_FLEET_ID_FIELD, CLUSTER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddInstanceFleetResponse.memberNameToFieldInitializer();
    private final String clusterId;
    private final String instanceFleetId;
    private final String clusterArn;

    private AddInstanceFleetResponse(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceFleetId = builder.instanceFleetId;
        this.clusterArn = builder.clusterArn;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final String instanceFleetId() {
        return this.instanceFleetId;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceFleetResponse)) {
            return false;
        }
        AddInstanceFleetResponse other = (AddInstanceFleetResponse)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.instanceFleetId(), other.instanceFleetId()) && Objects.equals(this.clusterArn(), other.clusterArn());
    }

    public final String toString() {
        return ToString.builder((String)"AddInstanceFleetResponse").add("ClusterId", (Object)this.clusterId()).add("InstanceFleetId", (Object)this.instanceFleetId()).add("ClusterArn", (Object)this.clusterArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "InstanceFleetId": {
                return Optional.ofNullable(clazz.cast(this.instanceFleetId()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("InstanceFleetId", INSTANCE_FLEET_ID_FIELD);
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddInstanceFleetResponse, T> g) {
        return obj -> g.apply((AddInstanceFleetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private String clusterId;
        private String instanceFleetId;
        private String clusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AddInstanceFleetResponse model) {
            super(model);
            this.clusterId(model.clusterId);
            this.instanceFleetId(model.instanceFleetId);
            this.clusterArn(model.clusterArn);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getInstanceFleetId() {
            return this.instanceFleetId;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        @Override
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        @Override
        public AddInstanceFleetResponse build() {
            return new AddInstanceFleetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddInstanceFleetResponse> {
        public Builder clusterId(String var1);

        public Builder instanceFleetId(String var1);

        public Builder clusterArn(String var1);
    }
}

