/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfig;
import software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EbsConfiguration> {
    private static final SdkField<List<EbsBlockDeviceConfig>> EBS_BLOCK_DEVICE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EbsBlockDeviceConfigs").getter(EbsConfiguration.getter(EbsConfiguration::ebsBlockDeviceConfigs)).setter(EbsConfiguration.setter(Builder::ebsBlockDeviceConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsBlockDeviceConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EbsBlockDeviceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(EbsConfiguration.getter(EbsConfiguration::ebsOptimized)).setter(EbsConfiguration.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_BLOCK_DEVICE_CONFIGS_FIELD, EBS_OPTIMIZED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EbsBlockDeviceConfigs", EBS_BLOCK_DEVICE_CONFIGS_FIELD);
            this.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<EbsBlockDeviceConfig> ebsBlockDeviceConfigs;
    private final Boolean ebsOptimized;

    private EbsConfiguration(BuilderImpl builder) {
        this.ebsBlockDeviceConfigs = builder.ebsBlockDeviceConfigs;
        this.ebsOptimized = builder.ebsOptimized;
    }

    public final boolean hasEbsBlockDeviceConfigs() {
        return this.ebsBlockDeviceConfigs != null && !(this.ebsBlockDeviceConfigs instanceof SdkAutoConstructList);
    }

    public final List<EbsBlockDeviceConfig> ebsBlockDeviceConfigs() {
        return this.ebsBlockDeviceConfigs;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEbsBlockDeviceConfigs() ? this.ebsBlockDeviceConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsConfiguration)) {
            return false;
        }
        EbsConfiguration other = (EbsConfiguration)obj;
        return this.hasEbsBlockDeviceConfigs() == other.hasEbsBlockDeviceConfigs() && Objects.equals(this.ebsBlockDeviceConfigs(), other.ebsBlockDeviceConfigs()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized());
    }

    public final String toString() {
        return ToString.builder((String)"EbsConfiguration").add("EbsBlockDeviceConfigs", this.hasEbsBlockDeviceConfigs() ? this.ebsBlockDeviceConfigs() : null).add("EbsOptimized", (Object)this.ebsOptimized()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EbsBlockDeviceConfigs": {
                return Optional.ofNullable(clazz.cast(this.ebsBlockDeviceConfigs()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EbsConfiguration, T> g) {
        return obj -> g.apply((EbsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EbsBlockDeviceConfig> ebsBlockDeviceConfigs = DefaultSdkAutoConstructList.getInstance();
        private Boolean ebsOptimized;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsConfiguration model) {
            this.ebsBlockDeviceConfigs(model.ebsBlockDeviceConfigs);
            this.ebsOptimized(model.ebsOptimized);
        }

        public final List<EbsBlockDeviceConfig.Builder> getEbsBlockDeviceConfigs() {
            List<EbsBlockDeviceConfig.Builder> result = EbsBlockDeviceConfigListCopier.copyToBuilder(this.ebsBlockDeviceConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEbsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig.BuilderImpl> ebsBlockDeviceConfigs) {
            this.ebsBlockDeviceConfigs = EbsBlockDeviceConfigListCopier.copyFromBuilder(ebsBlockDeviceConfigs);
        }

        @Override
        public final Builder ebsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig> ebsBlockDeviceConfigs) {
            this.ebsBlockDeviceConfigs = EbsBlockDeviceConfigListCopier.copy(ebsBlockDeviceConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsBlockDeviceConfigs(EbsBlockDeviceConfig ... ebsBlockDeviceConfigs) {
            this.ebsBlockDeviceConfigs(Arrays.asList(ebsBlockDeviceConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsBlockDeviceConfigs(Consumer<EbsBlockDeviceConfig.Builder> ... ebsBlockDeviceConfigs) {
            this.ebsBlockDeviceConfigs(Stream.of(ebsBlockDeviceConfigs).map(c -> (EbsBlockDeviceConfig)((EbsBlockDeviceConfig.Builder)EbsBlockDeviceConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public EbsConfiguration build() {
            return new EbsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EbsConfiguration> {
        public Builder ebsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig> var1);

        public Builder ebsBlockDeviceConfigs(EbsBlockDeviceConfig ... var1);

        public Builder ebsBlockDeviceConfigs(Consumer<EbsBlockDeviceConfig.Builder> ... var1);

        public Builder ebsOptimized(Boolean var1);
    }
}

