/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.ComputeLimitsUnitType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeLimits
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeLimits> {
    private static final SdkField<String> UNIT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnitType").getter(ComputeLimits.getter(ComputeLimits::unitTypeAsString)).setter(ComputeLimits.setter(Builder::unitType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnitType").build()}).build();
    private static final SdkField<Integer> MINIMUM_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumCapacityUnits").getter(ComputeLimits.getter(ComputeLimits::minimumCapacityUnits)).setter(ComputeLimits.setter(Builder::minimumCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumCapacityUnits").build()}).build();
    private static final SdkField<Integer> MAXIMUM_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumCapacityUnits").getter(ComputeLimits.getter(ComputeLimits::maximumCapacityUnits)).setter(ComputeLimits.setter(Builder::maximumCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumCapacityUnits").build()}).build();
    private static final SdkField<Integer> MAXIMUM_ON_DEMAND_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumOnDemandCapacityUnits").getter(ComputeLimits.getter(ComputeLimits::maximumOnDemandCapacityUnits)).setter(ComputeLimits.setter(Builder::maximumOnDemandCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumOnDemandCapacityUnits").build()}).build();
    private static final SdkField<Integer> MAXIMUM_CORE_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumCoreCapacityUnits").getter(ComputeLimits.getter(ComputeLimits::maximumCoreCapacityUnits)).setter(ComputeLimits.setter(Builder::maximumCoreCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumCoreCapacityUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIT_TYPE_FIELD, MINIMUM_CAPACITY_UNITS_FIELD, MAXIMUM_CAPACITY_UNITS_FIELD, MAXIMUM_ON_DEMAND_CAPACITY_UNITS_FIELD, MAXIMUM_CORE_CAPACITY_UNITS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UnitType", UNIT_TYPE_FIELD);
            this.put("MinimumCapacityUnits", MINIMUM_CAPACITY_UNITS_FIELD);
            this.put("MaximumCapacityUnits", MAXIMUM_CAPACITY_UNITS_FIELD);
            this.put("MaximumOnDemandCapacityUnits", MAXIMUM_ON_DEMAND_CAPACITY_UNITS_FIELD);
            this.put("MaximumCoreCapacityUnits", MAXIMUM_CORE_CAPACITY_UNITS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String unitType;
    private final Integer minimumCapacityUnits;
    private final Integer maximumCapacityUnits;
    private final Integer maximumOnDemandCapacityUnits;
    private final Integer maximumCoreCapacityUnits;

    private ComputeLimits(BuilderImpl builder) {
        this.unitType = builder.unitType;
        this.minimumCapacityUnits = builder.minimumCapacityUnits;
        this.maximumCapacityUnits = builder.maximumCapacityUnits;
        this.maximumOnDemandCapacityUnits = builder.maximumOnDemandCapacityUnits;
        this.maximumCoreCapacityUnits = builder.maximumCoreCapacityUnits;
    }

    public final ComputeLimitsUnitType unitType() {
        return ComputeLimitsUnitType.fromValue(this.unitType);
    }

    public final String unitTypeAsString() {
        return this.unitType;
    }

    public final Integer minimumCapacityUnits() {
        return this.minimumCapacityUnits;
    }

    public final Integer maximumCapacityUnits() {
        return this.maximumCapacityUnits;
    }

    public final Integer maximumOnDemandCapacityUnits() {
        return this.maximumOnDemandCapacityUnits;
    }

    public final Integer maximumCoreCapacityUnits() {
        return this.maximumCoreCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unitTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumOnDemandCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumCoreCapacityUnits());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeLimits)) {
            return false;
        }
        ComputeLimits other = (ComputeLimits)obj;
        return Objects.equals(this.unitTypeAsString(), other.unitTypeAsString()) && Objects.equals(this.minimumCapacityUnits(), other.minimumCapacityUnits()) && Objects.equals(this.maximumCapacityUnits(), other.maximumCapacityUnits()) && Objects.equals(this.maximumOnDemandCapacityUnits(), other.maximumOnDemandCapacityUnits()) && Objects.equals(this.maximumCoreCapacityUnits(), other.maximumCoreCapacityUnits());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeLimits").add("UnitType", (Object)this.unitTypeAsString()).add("MinimumCapacityUnits", (Object)this.minimumCapacityUnits()).add("MaximumCapacityUnits", (Object)this.maximumCapacityUnits()).add("MaximumOnDemandCapacityUnits", (Object)this.maximumOnDemandCapacityUnits()).add("MaximumCoreCapacityUnits", (Object)this.maximumCoreCapacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnitType": {
                return Optional.ofNullable(clazz.cast(this.unitTypeAsString()));
            }
            case "MinimumCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.minimumCapacityUnits()));
            }
            case "MaximumCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.maximumCapacityUnits()));
            }
            case "MaximumOnDemandCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.maximumOnDemandCapacityUnits()));
            }
            case "MaximumCoreCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.maximumCoreCapacityUnits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ComputeLimits, T> g) {
        return obj -> g.apply((ComputeLimits)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String unitType;
        private Integer minimumCapacityUnits;
        private Integer maximumCapacityUnits;
        private Integer maximumOnDemandCapacityUnits;
        private Integer maximumCoreCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeLimits model) {
            this.unitType(model.unitType);
            this.minimumCapacityUnits(model.minimumCapacityUnits);
            this.maximumCapacityUnits(model.maximumCapacityUnits);
            this.maximumOnDemandCapacityUnits(model.maximumOnDemandCapacityUnits);
            this.maximumCoreCapacityUnits(model.maximumCoreCapacityUnits);
        }

        public final String getUnitType() {
            return this.unitType;
        }

        public final void setUnitType(String unitType) {
            this.unitType = unitType;
        }

        @Override
        public final Builder unitType(String unitType) {
            this.unitType = unitType;
            return this;
        }

        @Override
        public final Builder unitType(ComputeLimitsUnitType unitType) {
            this.unitType(unitType == null ? null : unitType.toString());
            return this;
        }

        public final Integer getMinimumCapacityUnits() {
            return this.minimumCapacityUnits;
        }

        public final void setMinimumCapacityUnits(Integer minimumCapacityUnits) {
            this.minimumCapacityUnits = minimumCapacityUnits;
        }

        @Override
        public final Builder minimumCapacityUnits(Integer minimumCapacityUnits) {
            this.minimumCapacityUnits = minimumCapacityUnits;
            return this;
        }

        public final Integer getMaximumCapacityUnits() {
            return this.maximumCapacityUnits;
        }

        public final void setMaximumCapacityUnits(Integer maximumCapacityUnits) {
            this.maximumCapacityUnits = maximumCapacityUnits;
        }

        @Override
        public final Builder maximumCapacityUnits(Integer maximumCapacityUnits) {
            this.maximumCapacityUnits = maximumCapacityUnits;
            return this;
        }

        public final Integer getMaximumOnDemandCapacityUnits() {
            return this.maximumOnDemandCapacityUnits;
        }

        public final void setMaximumOnDemandCapacityUnits(Integer maximumOnDemandCapacityUnits) {
            this.maximumOnDemandCapacityUnits = maximumOnDemandCapacityUnits;
        }

        @Override
        public final Builder maximumOnDemandCapacityUnits(Integer maximumOnDemandCapacityUnits) {
            this.maximumOnDemandCapacityUnits = maximumOnDemandCapacityUnits;
            return this;
        }

        public final Integer getMaximumCoreCapacityUnits() {
            return this.maximumCoreCapacityUnits;
        }

        public final void setMaximumCoreCapacityUnits(Integer maximumCoreCapacityUnits) {
            this.maximumCoreCapacityUnits = maximumCoreCapacityUnits;
        }

        @Override
        public final Builder maximumCoreCapacityUnits(Integer maximumCoreCapacityUnits) {
            this.maximumCoreCapacityUnits = maximumCoreCapacityUnits;
            return this;
        }

        public ComputeLimits build() {
            return new ComputeLimits(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeLimits> {
        public Builder unitType(String var1);

        public Builder unitType(ComputeLimitsUnitType var1);

        public Builder minimumCapacityUnits(Integer var1);

        public Builder maximumCapacityUnits(Integer var1);

        public Builder maximumOnDemandCapacityUnits(Integer var1);

        public Builder maximumCoreCapacityUnits(Integer var1);
    }
}

